
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
land_types = [
    "Forest",
    "Urban",
    "Agriculture",
    "Water Bodies",
    "Desert",
    "Others",
]

data = [40, 20, 25, 5, 7, 3]  # Percentage distribution of land types
title = "Geographical Distribution of Land Types"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#228B22", "#A9A9A9", "#FFD700", "#1E90FF", "#DEB887", "#D3D3D3"]
fig, ax = plt.subplots(figsize=(8, 6), subplot_kw=dict(aspect="equal"))
wedges, texts = ax.pie(data, wedgeprops=dict(width=0.5), startangle=-40, colors=colors)


bbox_props = dict(boxstyle="square,pad=0.3", fc="w", ec="k", lw=0.72)
kw = dict(arrowprops=dict(arrowstyle="-"), bbox=bbox_props, zorder=0, va="center")

for i, p in enumerate(wedges):
    ang = (p.theta2 - p.theta1) / 2.0 + p.theta1
    y = np.sin(np.deg2rad(ang))
    x = np.cos(np.deg2rad(ang))
    horizontalalignment = {-1: "right", 1: "left"}[int(np.sign(x))]
    connectionstyle = f"angle,angleA=0,angleB={ang}"
    kw["arrowprops"].update({"connectionstyle": connectionstyle})
    ax.annotate(
        land_types[i],
        xy=(x, y),
        xytext=(1.35 * np.sign(x), 1.4 * y),
        horizontalalignment=horizontalalignment,
        **kw,
    )

# Adding a legend
ax.legend(wedges, land_types, title="Land Types", loc="center left", bbox_to_anchor=(1, 0, 0.5, 1))

ax.set_title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("pie_49.pdf", bbox_inches="tight")
