
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

labels = ["Materials", "Labor", "Marketing", "Technology", "Miscellaneous"]
outer_sizes = [500, 300, 100, 150, 50]  # Art project expenses
inner_sizes = [200, 150, 80, 100, 40]  # Design project expenses

title = "Expenses - Art Project vs. Design Project"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 8))

outer_colors = ["#FFB6C1", "#87CEFA", "#98FB98", "#FFD700", "#D8BFD8"]
inner_colors = ["#FF69B4", "#4682B4", "#ADFF2F", "#FFA500", "#DA70D6"]
outer_hatch = ["/", "\\", "|", "-", "+"]  # Different hatching for outer ring
inner_hatch = ["x", "*", "o", "O", "."]  # Different hatching for inner ring

explode_outer = (0.1, 0, 0, 0, 0)  # only explode the 1st slice (Materials)

# Outer ring
wedges, texts, autotexts = ax.pie(
    outer_sizes,
    labels=labels,
    radius=1.2,
    colors=outer_colors,
    explode=explode_outer,
    autopct="%1.1f%%",
    pctdistance=0.85,
    startangle=160,
    wedgeprops=dict(width=0.3, edgecolor="w", hatch="*"),
)

# Inner ring
wedges2, texts2, autotexts2 = ax.pie(
    inner_sizes,
    radius=0.9,
    colors=inner_colors,
    autopct="%1.1f%%",
    pctdistance=0.75,
    startangle=160,
    wedgeprops=dict(width=0.3, edgecolor="w", hatch="o"),
)

# Customizing the autotexts for better visibility
for autotext in autotexts + autotexts2:
    autotext.set_color("black")
    autotext.set_fontsize(10)

# Title for the double layer pie chart
ax.set_title(title, fontsize=16, y=1.05)

# ===================
# Part 4: Saving Output
# ===================
# Improve layout to make room for legend or labels if necessary
plt.tight_layout()

# Show the plot
plt.savefig("pie_51.pdf", bbox_inches="tight")
