
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for the charts
labels = ["Emails", "Calls", "Meetings", "Unused"]
traditional_communication_data = [25.0, 30.0, 20.0, 25.0]
modern_communication_data = [30.0, 25.0, 15.0, 30.0]

titles = ["Traditional Communication", "Modern Communication"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure with specific dimensions
fig, ax = plt.subplots(1, 2, figsize=(12, 6))

# New Color Scheme
colors = ["#4c72b0", "#55a868", "#c44e52", "#8172b3"]

# Traditional Communication Donut Chart
explode1 = (0.1, 0, 0, 0)
ax[0].pie(
    traditional_communication_data,
    labels=labels,
    colors=colors,
    startangle=90,
    counterclock=False,
    wedgeprops=dict(width=0.3),
    explode=explode1,
    autopct="%1.1f%%",
    pctdistance=0.85,
)
ax[0].set_title(titles[0], fontsize=14)

# Modern Communication Donut Chart
explode2 = (0, 0.1, 0, 0)
ax[1].pie(
    modern_communication_data,
    labels=labels,
    colors=colors,
    startangle=90,
    counterclock=False,
    wedgeprops=dict(width=0.3),
    explode=explode2,
    autopct="%1.1f%%",
    pctdistance=0.85,
)
ax[1].set_title(titles[1], fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlap and Show plot
plt.tight_layout()
plt.savefig("pie_55.pdf", bbox_inches="tight")
