
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for the charts
labels_renewable = ["Solar", "Wind", "Hydro", "Geothermal"]
renewable_data = [35.0, 25.0, 30.0, 10.0]

labels_non_renewable = ["Coal", "Oil", "Natural Gas", "Nuclear"]
non_renewable_data = [40.0, 30.0, 20.0, 10.0]

titles = ["Renewable Energy Mix", "Non-Renewable Energy Mix"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure with specific dimensions
fig, ax = plt.subplots(1, 2, figsize=(12, 6))

# Define color palettes
colors_renewable = ["#66c2a5", "#fc8d62", "#8da0cb", "#e78ac3"]
colors_non_renewable = ["#a6d854", "#ffd92f", "#e5c494", "#b3b3b3"]

# Renewable Energy Donut Chart
explode1 = (0.1, 0, 0, 0)
ax[0].pie(
    renewable_data,
    labels=labels_renewable,
    colors=colors_renewable,
    startangle=140,
    counterclock=False,
    wedgeprops=dict(width=0.3),
    explode=explode1,
    autopct="%1.1f%%",
)
ax[0].set_title(titles[0])

# Non-Renewable Energy Donut Chart
explode2 = (0, 0.1, 0, 0.1)
ax[1].pie(
    non_renewable_data,
    labels=labels_non_renewable,
    colors=colors_non_renewable,
    startangle=140,
    counterclock=False,
    wedgeprops=dict(width=0.3),
    explode=explode2,
    autopct="%1.1f%%",
)
ax[1].set_title(titles[1])

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlap and Show plot
plt.tight_layout()
plt.savefig("pie_56.pdf", bbox_inches="tight")
