
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for the charts
categories = ["Sketching", "Modeling", "Rendering", "Review"]
traditional_design_data = [20, 30, 25, 25]
digital_design_data = [15, 25, 40, 20]

# Variables for plot configuration
traditional_design_label = "Traditional Design Methods"
digital_design_label = "Digital Design Methods"
legend_labels = categories
legend_loc = "lower center"

title_traditional_design = "Traditional Design Methods"
title_digital_design = "Digital Design Methods"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure with specific dimensions
fig, ax = plt.subplots(2, 1, figsize=(7, 10))

# New color scheme for art and design domain
colors = ["#5DADE2", "#48C9B0", "#F1948A", "#AF7AC5"]
legend_ncol = 4
legend_frameon = False
wedgeprops_dict = dict(width=0.3)
startangle = 90
counterclock = False

# Traditional Design Methods Donut Chart
ax[0].pie(
    traditional_design_data,
    labels=traditional_design_data,
    colors=colors,
    startangle=startangle,
    counterclock=counterclock,
    wedgeprops=wedgeprops_dict,
)
ax[0].set_title(title_traditional_design)

# Digital Design Methods Donut Chart
ax[1].pie(
    digital_design_data,
    labels=digital_design_data,
    colors=colors,
    startangle=startangle,
    counterclock=counterclock,
    wedgeprops=wedgeprops_dict,
)
ax[1].set_title(title_digital_design)

# Add legend
fig.legend(legend_labels, loc=legend_loc, ncol=legend_ncol, frameon=legend_frameon)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlap and Show plot
plt.tight_layout()
plt.savefig("pie_57.pdf", bbox_inches="tight")
