
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for the charts
categories = ["Accommodations", "Transportation", "Food & Beverages", "Activities"]
spring_data = [25.0, 30.0, 20.0, 25.0]
summer_data = [35.0, 25.0, 15.0, 25.0]

# Variables for plot configuration
spring_label = "Spring Season"
summer_label = "Summer Season"
legend_labels = categories
legend_loc = "upper center"

title_spring = "Spring Tourism Distribution"
title_summer = "Summer Tourism Distribution"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure with specific dimensions
fig, ax = plt.subplots(2, 1, figsize=(6, 10))

colors = ["#87CEEB", "#228B22", "#F4A460", "#FF4500"]
legend_ncol = 2
legend_frameon = True
wedgeprops_dict = dict(width=0.3)
startangle = 90
counterclock = False

# Spring Tourism Donut Chart
ax[0].pie(
    spring_data,
    labels=spring_data,
    colors=colors,
    startangle=startangle,
    counterclock=counterclock,
    wedgeprops=wedgeprops_dict,
)
ax[0].set_title(title_spring)

# Summer Tourism Donut Chart
ax[1].pie(
    summer_data,
    labels=summer_data,
    colors=colors,
    startangle=startangle,
    counterclock=counterclock,
    wedgeprops=wedgeprops_dict,
)
ax[1].set_title(title_summer)

# Add legend
fig.legend(legend_labels, loc=legend_loc, ncol=legend_ncol, frameon=legend_frameon, bbox_to_anchor=(0.5, 0.05))

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlap and Show plot
plt.tight_layout()
plt.savefig("pie_58.pdf", bbox_inches="tight")
