
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Example data for population distribution across continents (in percentage)
categories = ["Asia", "Africa", "Europe", "North America", "South America", "Oceania"]
sizes = [60, 17, 10, 7, 5, 1]

# Variables for plot configuration
title_text = "World Population Distribution by Continent"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 8))

# New colors for better visualization
colors = ["#ff9999", "#66b3ff", "#99ff99", "#ffcc99", "#c2c2f0", "#ffb3e6"]
explode = (0.1, 0, 0, 0, 0, 0)  # Slightly "explode" the first slice (Asia)

# The pie function also handles donuts with the 'wedgeprops' argument
wedges, texts, autotexts = ax.pie(
    sizes,
    labels=categories,
    colors=colors,
    autopct="%1.1f%%",
    startangle=140,
    explode=explode,
    wedgeprops=dict(width=0.2, edgecolor="w"),  # Adjust width for better visualization
    textprops={'fontsize': 12}  # Adjust font size for better readability
)

# Draw a circle at the center of the pie to make it a donut
centre_circle = plt.Circle((0, 0), 0.65, fc="white")
fig.gca().add_artist(centre_circle)

# Equal aspect ratio ensures that the pie is drawn as a circle
ax.axis("equal")

# Set title for the donut chart
ax.set_title(title_text, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("pie_60.pdf", bbox_inches="tight")

