
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data to plot
parties = ["Party A", "Party B", "Party C", "Party D", "Party E"]
seats = [45, 25, 15, 10, 5]

# Plot configuration variables
title_text = "Distribution of Seats in the Parliament"
xlabel = "Political Parties"
ylabel = "Number of Seats"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
explode = (0.1, 0, 0, 0, 0)  # explode the first slice
colors = ["#4E79A7", "#F28E2B", "#E15759", "#76B7B2", "#59A14F"]
title_pad = 20
title_fontsize = 18
legend_loc = "center left"
legend_bbox_to_anchor = (1, 0, 0.5, 1)
autopct_format = "%1.1f%%"
startangle = 90
wedgeprops = dict(edgecolor="k", linewidth=1.5)

# Plot
fig, ax = plt.subplots(figsize=(10, 7))
ax.pie(
    seats,
    colors=colors,
    autopct=autopct_format,
    startangle=startangle,
    wedgeprops=wedgeprops,
    explode=explode,
)

# Adding a title and legend
ax.set_title(title_text, pad=title_pad, fontsize=title_fontsize)
ax.legend(parties, loc=legend_loc, bbox_to_anchor=legend_bbox_to_anchor)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("pie_67.pdf", bbox_inches="tight")

