
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data to plot
sizes = [
    20.4,
    18.3,
    25.1,
    15.7,
    10.6,
    9.9,
]  # Example new data of population percentages
labels = ["0-14 years", "15-24 years", "25-54 years", "55-64 years", "65+ years", "Others"]

# Plot configuration
title = "Population Distribution by Age Group"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
explode = (0.1, 0, 0.2, 0, 0.2, 0.2)  # add explode parameter to separate slices
title_pad = 20
autopct_format = "%1.1f%%"
startangle = 140
wedgeprops = dict(edgecolor="w", linewidth=2)

# Colors chosen for better visualization
colors = ["#4F81BD", "#C0504D", "#9BBB59", "#8064A2", "#4BACC6", "#F79646"]

# Plot
fig, ax = plt.subplots(figsize=(8, 8))
ax.pie(
    sizes,
    colors=colors,
    autopct=autopct_format,
    startangle=startangle,
    wedgeprops=wedgeprops,
    explode=explode,
    labels=labels,
)
ax.set_title(title, pad=title_pad)  # Set the title with padding

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("pie_71.pdf", bbox_inches="tight")
