
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
labels = ["Facebook 35%", "Instagram 25%", "Twitter 20%", "LinkedIn 15%", "Others 5%"]
sizes = [35, 25, 20, 15, 5]
title = "Social Media Usage Distribution"
xlabel = "Social Media Platforms"
ylabel = "Usage Percentage"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
autopct_format = "%1.1f%%"
startangle = 140
pctdistance = 0.85
centre_circle_radius = 0.70
fig, ax = plt.subplots(figsize=(8, 8))
colors = [
    "#1DA1F2",
    "#E1306C",
    "#3B5998",
    "#0077B5",
    "#FFCC00",
]  # Twitter Blue, Instagram Pink, Facebook Blue, LinkedIn Blue, Others Yellow
hatches = ["//", "\\\\", "||", "--", "xx"]

ax.pie(
    sizes,
    labels=labels,
    colors=colors,
    autopct=autopct_format,
    startangle=startangle,
    hatch=hatches,
    shadow=True,
    pctdistance=pctdistance,
)
plt.title(title, fontsize=16)

# Draw center circle for a donut effect
centre_circle = plt.Circle((0, 0), centre_circle_radius, fc="white")
fig.gca().add_artist(centre_circle)

# Ensure that pie is drawn as a circle.
ax.axis("equal")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("pie_72.pdf", bbox_inches="tight")
