
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
labels = ["Cloud Services 35%", "Artificial Intelligence 30%", "Blockchain 20%", "IoT 15%"]
sizes = [35, 30, 20, 15]
title = "Technology Adoption Distribution 2023"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
autopct_format = "%1.1f%%"
startangle = 140
pctdistance = 0.85
centre_circle_radius = 0.70
fig, ax = plt.subplots(figsize=(8, 8))
colors = [
    "#1f77b4",  # Blue
    "#ff7f0e",  # Orange
    "#2ca02c",  # Green
    "#d62728",  # Red
]
hatches = ['/', '\\', '|', '-']
ax.pie(
    sizes,
    labels=labels,
    colors=colors,
    autopct=autopct_format,
    startangle=startangle,
    hatch=hatches,
    shadow=True,
    pctdistance=pctdistance,
)
plt.title(title, fontsize=14, fontweight='bold')

# Draw center circle for a donut effect
centre_circle = plt.Circle((0, 0), centre_circle_radius, fc="white")
fig.gca().add_artist(centre_circle)

# Ensure that pie is drawn as a circle.
ax.axis("equal")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("pie_73.pdf", bbox_inches="tight")
