
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
labels = ["Math 35%", "Science 30%", "Literature 20%", "History 15%"]
sizes = [35, 30, 20, 15]
title = "Popularity Distribution of School Subjects"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
autopct_format = "%1.1f%%"
startangle = 140
pctdistance = 0.85
centre_circle_radius = 0.70
fig, ax = plt.subplots(figsize=(7, 7))
colors = [
    "#8B0000",  # Dark Red
    "#4682B4",  # Steel Blue
    "#2E8B57",  # Sea Green
    "#FF8C00",  # Dark Orange
]
hatches = ["/", "\\", "|", "-"]

ax.pie(
    sizes,
    labels=labels,
    colors=colors,
    autopct=autopct_format,
    startangle=startangle,
    hatch=hatches,
    shadow=True,
    pctdistance=pctdistance,
)
plt.title(title)

# Draw center circle for a donut effect
centre_circle = plt.Circle((0, 0), centre_circle_radius, fc="white")
fig.gca().add_artist(centre_circle)

# Ensure that pie is drawn as a circle.
ax.axis("equal")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("pie_74.pdf", bbox_inches="tight")
