
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Data to plot
labels = ["Corporate Law", "Criminal Law", "Family Law", "Intellectual Property", "Environmental Law"]
sizes = [40, 25, 15, 10, 10]


# Extracted variables
plot_title = "Distribution of Legal Practice Areas"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#2E8B57", "#556B2F", "#8FBC8F", "#4682B4", "#B0C4DE"]
explode = (0.1, 0, 0, 0, 0)  # Highlight the largest segment (Corporate Law)
autopct_format = "%1.1f%%"
shadow_option = True
start_angle = 140
legend_location = "upper left"
legend_fontsize = 12
title_fontsize = 18
title_y_position = 1.03

# Plot
plt.figure(figsize=(10, 7))
plt.pie(
    sizes,
    explode=explode,
    colors=colors,
    autopct=autopct_format,
    shadow=shadow_option,  # Add shadow for depth
    startangle=start_angle,
)
plt.axis("equal")

# Add legend
plt.legend(labels, loc=legend_location, fontsize=legend_fontsize)
plt.title(plot_title, fontsize=title_fontsize, y=title_y_position)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("pie_80.pdf", bbox_inches="tight")

