
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines
import matplotlib.patches as mpatches


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)


# Define the vector field function for ocean currents
def surface_currents(X, Y):
    U = -Y
    V = X
    return U, V


def deep_currents(X, Y):
    U = -1 - X**2 + Y
    V = 1 + X - Y**2
    return U, V


# Create a grid of points for the vector field
x = np.linspace(0, 0.6, 10)
y = np.linspace(0, 0.6, 10)
X, Y = np.meshgrid(x, y)

# Compute the vector field for surface and deep currents
U_surface, V_surface = surface_currents(X, Y)
U_deep, V_deep = deep_currents(X, Y)

# Plot simulated paths as curves
x = np.linspace(0.2, 0.5, 100)
xlabel = "Longitude"
ylabel = "Latitude"
patch_labels = ["Surface Currents", "Deep Currents"]
line_labels = ["Recorded Path", "Simulated Path A", "Simulated Path B", "Simulated Path C"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(8, 6))
plt.quiver(X, Y, U_surface, V_surface, color="#1f77b4", alpha=0.7)  # Blue color for surface currents
plt.quiver(X, Y, U_deep, V_deep, color="#ff7f0e", alpha=0.7)  # Orange color for deep currents
plt.plot(x, 0.09 / (x**1.2), color="#2ca02c", linestyle="--", linewidth=1.5)  # Green dashed line
plt.plot(x, 0.08 / (x**1.2 + 0.04), color="#d62728", linestyle=":", linewidth=1.5)  # Red dotted line
plt.plot(x, 0.075 / (x**1 + 0.04), color="#9467bd", linestyle="-.", linewidth=1.5)  # Purple dash-dot line
plt.plot(x, 0.12 / (x**1 + 0.05), color="#8c564b", linestyle="-", linewidth=1.5)  # Brown solid line

# Add labels and legend
plt.xlabel(xlabel, fontsize=14, style="italic")
plt.ylabel(ylabel, fontsize=14, style="italic")

surface_patch = mpatches.Patch(color="#1f77b4", label=patch_labels[0], alpha=0.7)
deep_patch = mpatches.Patch(color="#ff7f0e", label=patch_labels[1], alpha=0.7)

# Create legend for curves
recorded_line = mlines.Line2D([], [], color="#2ca02c", linestyle="--", linewidth=1.5, label=line_labels[0])
simulated_path_a = mlines.Line2D([], [], color="#d62728", linestyle=":", linewidth=1.5, label=line_labels[1])
simulated_path_b = mlines.Line2D([], [], color="#9467bd", linestyle="-.", linewidth=1.5, label=line_labels[2])
simulated_path_c = mlines.Line2D([], [], color="#8c564b", linestyle="-", linewidth=1.5, label=line_labels[3])

# Combine all legend handles
handles = [
    surface_patch,
    deep_patch,
    recorded_line,
    simulated_path_a,
    simulated_path_b,
    simulated_path_c,
]

# Add the legend to the plot with specified location
plt.legend(handles=handles, loc="lower left")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("quiver_29.pdf", bbox_inches="tight")
