# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)


# Define the vector field function
def vector_field(X, Y):
    # Creating a pattern for an aesthetically pleasing philosophical representation
    U = -Y
    V = X / 2
    return U, V


# Create a grid of points
x = np.linspace(-1.0, 1.0, 20)
y = np.linspace(-1.0, 1.0, 20)
X, Y = np.meshgrid(x, y)

# Compute the vector field
U, V = vector_field(X, Y)

# Labels and title
xlabel = "Axis of Thought"
ylabel = "Axis of Existence"
title = "Philosophical Flow: The Harmony of Thought and Existence"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(6, 5))

# Plot the vector field
ax.quiver(X, Y, U, V, color="#2a9d8f")

# Set labels and title
ax.set_xlabel(xlabel, fontsize=12, fontweight="bold")
ax.set_ylabel(ylabel, fontsize=12, fontweight="bold")
ax.set_title(title, fontsize=14, fontweight="bold", color="#264653")

# Show grid with a specific style
ax.grid(True, linestyle=":", alpha=0.8, color="#e9c46a")

# Enhance the visual quality of the plot
ax.set_aspect("equal")
ax.set_facecolor("#f0f8ff")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("quiver_30.pdf", bbox_inches="tight")
