# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)


# Define the vector field function to simulate political movement
def political_vector_field(X, Y):
    U = np.cos(X) - np.sin(Y)
    V = np.sin(X) + np.cos(Y)
    return U, V


# Create a grid of points
x = np.linspace(-2.0, 2.0, 20)
y = np.linspace(-2.0, 2.0, 20)
X, Y = np.meshgrid(x, y)

# Compute the vector field
U, V = political_vector_field(X, Y)
xlabel = "Region X"
ylabel = "Region Y"
title = "Political Movement Vector Field"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(8, 6))
ax.quiver(X, Y, U, V, color="#ff6347")  # Tomato color for vectors

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Show grid
ax.grid(True, linestyle="--", alpha=0.7)

# Use a colormap to represent different vector magnitudes
magnitude = np.sqrt(U**2 + V**2)
ax.quiver(X, Y, U, V, magnitude, cmap="coolwarm")

# Add a color bar to represent the magnitude
cbar = plt.colorbar(ax.quiver(X, Y, U, V, magnitude, cmap="coolwarm"), ax=ax)
cbar.set_label("Magnitude")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("quiver_32.pdf", bbox_inches="tight")
