
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)


# Define the vector field function symbolizing philosophical duality
def vector_field(X, Y):
    # Radial vector field: vectors point towards or away from the origin
    U = X
    V = Y
    return U, V


# Create a finer grid of points
x = np.linspace(-2.0, 2.0, 20)
y = np.linspace(-2.0, 2.0, 20)
X, Y = np.meshgrid(x, y)

# Compute the vector field
U, V = vector_field(X, Y)
xlabel = "Conceptual Space X"
ylabel = "Conceptual Space Y"
title = "Duality of Thought in Conceptual Space"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(6, 5))

# Use a philosophical color scheme
colors = np.sqrt(U**2 + V**2)
quiver = ax.quiver(X, Y, U, V, colors, cmap="plasma")

# Add streamlines to the vector field plot to enhance flow representation
strm = ax.streamplot(X, Y, U, V, color='white', linewidth=0.8)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Show subtle grid
ax.grid(True, linestyle="--", alpha=0.3)

# Adjust the aspect ratio
ax.set_aspect("equal")

# Apply a dark background
ax.set_facecolor('black')

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Display the plot
plt.savefig("quiver_35.pdf", bbox_inches="tight")
