
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for the plot (Philosophers)
philosophers_1 = ["Socrates", "Plato", "Aristotle"]
popularity_initial_1 = [80, 70, 90]
popularity_change_1 = [15, 10, 20]
influence_initial_1 = [75, 85, 95]
influence_change_1 = [10, 5, 8]
ax1_labels = ["Popularity Growth", "Influence Growth"]

philosophers_2 = ["Descartes", "Kant", "Nietzsche"]
popularity_initial_2 = [60, 65, 55]
popularity_change_2 = [8, 12, 7]
influence_initial_2 = [80, 70, 60]
influence_change_2 = [6, 9, 5]
ax2_labels = ["Popularity Growth", "Influence Growth"]

# Chart labels
xlabel = "Index"
ylabel = "Philosophers"
supertitle = "Growth of Philosophical Impact"
legendlabels = ["Popularity Growth", "Influence Growth"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure with two subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 5))
fig.suptitle(supertitle, fontsize=16)

# Set the y-axis offsets to be in the middle of each grid
offset = 0.5

# First subplot (philosophers_1)
for i, philosopher in enumerate(philosophers_1):
    # Popularity growth line with arrow and green circle markers at start and end
    ax1.annotate(
        "",
        xy=(popularity_initial_1[i], i + offset * 3 / 2),
        xytext=(popularity_initial_1[i] + popularity_change_1[i], i + offset * 3 / 2),
        arrowprops=dict(arrowstyle="<|-", color="green"),
    )
    ax1.scatter(
        [popularity_initial_1[i], popularity_initial_1[i] + popularity_change_1[i]],
        [i + offset * 3 / 2, i + offset * 3 / 2],
        color="darkgreen",
        s=20,
        marker="o",
    )
    ax1.annotate(
        f"{popularity_change_1[i]:.2f}",
        (popularity_initial_1[i] + popularity_change_1[i], i + offset * 1.75),
        color="green",
        ha="right",
        va="center",
    )

    # Influence growth line with arrow and blue circle markers at start and end
    ax1.annotate(
        "",
        xy=(influence_initial_1[i], i + offset / 2),
        xytext=(influence_initial_1[i] + influence_change_1[i], i + offset / 2),
        arrowprops=dict(arrowstyle="<|-", color="blue"),
    )
    ax1.scatter(
        [
            influence_initial_1[i],
            influence_initial_1[i] + influence_change_1[i],
        ],
        [i + offset / 2, i + offset / 2],
        color="darkblue",
        s=20,
        marker="o",
    )
    ax1.annotate(
        f"{influence_change_1[i]:.2f}",
        (influence_initial_1[i] + influence_change_1[i], i + offset * 0.75),
        color="blue",
        ha="left",
        va="center",
    )

# Second subplot (philosophers_2)
for i, philosopher in enumerate(philosophers_2):
    ax2.annotate(
        "",
        xy=(popularity_initial_2[i], i + offset * 3 / 2),
        xytext=(popularity_initial_2[i] + popularity_change_2[i], i + offset * 3 / 2),
        arrowprops=dict(arrowstyle="<|-", color="green"),
    )
    ax2.scatter(
        [popularity_initial_2[i], popularity_initial_2[i] + popularity_change_2[i]],
        [i + offset * 3 / 2, i + offset * 3 / 2],
        color="darkgreen",
        s=20,
        marker="o",
    )
    ax2.annotate(
        f"{popularity_change_2[i]:.2f}",
        (popularity_initial_2[i] + popularity_change_2[i], i + offset * 1.75),
        color="green",
        ha="right",
        va="center",
    )

    ax2.annotate(
        "",
        xy=(influence_initial_2[i], i + offset / 2),
        xytext=(influence_initial_2[i] + influence_change_2[i], i + offset / 2),
        arrowprops=dict(arrowstyle="<|-", color="blue"),
    )
    ax2.scatter(
        [
            influence_initial_2[i],
            influence_initial_2[i] + influence_change_2[i],
        ],
        [i + offset / 2, i + offset / 2],
        color="darkblue",
        s=20,
        marker="o",
    )
    ax2.annotate(
        f"{influence_change_2[i]:.2f}",
        (influence_initial_2[i] + influence_change_2[i], i + offset * 0.75),
        color="blue",
        ha="left",
        va="center",
    )

# Set y-axis limits
ax1.set_ylim(0, len(philosophers_1))
ax2.set_ylim(0, len(philosophers_2))

# Set x-axis limits uniformly
ax1.set_xlim(0, 120)
ax2.set_xlim(0, 120)

# Adjust the y-axis tick positions
ax1.set_yticks([i + offset for i in range(len(philosophers_1))])
ax1.set_yticklabels(philosophers_1)
ax2.set_yticks([i + offset for i in range(len(philosophers_2))])
ax2.set_yticklabels(philosophers_2)
ax2.yaxis.tick_right()
ax2.yaxis.set_label_position("right")
ax1.set_xlabel(xlabel)
ax2.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)

# Offset grid lines on the y-axis
ax1.set_yticks([i for i in range(len(philosophers_1))], minor=True)
ax2.set_yticks([i for i in range(len(philosophers_2))], minor=True)
ax1.yaxis.grid(True, which="minor", linewidth=0.5, alpha=0.7, color="black")
ax2.yaxis.grid(True, which="minor", linewidth=0.5, alpha=0.7, color="black")

# Add x-axis grid lines and set gap to 10
ax1.xaxis.set_major_locator(plt.MultipleLocator(10))
ax2.xaxis.set_major_locator(plt.MultipleLocator(10))
ax1.grid(axis="x", linestyle="--", linewidth=0.5)
ax2.grid(axis="x", linestyle="--", linewidth=0.5)

# Create arrow-shaped legend entries with a line that aligns with the arrowhead
green_arrow = mlines.Line2D(
    [],
    [],
    color="green",
    marker=">",
    linestyle="-",
    markersize=8,
    label=legendlabels[0],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
blue_arrow = mlines.Line2D(
    [],
    [],
    color="blue",
    marker=">",
    linestyle="-",
    markersize=8,
    label=legendlabels[1],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
fig.legend(handles=[green_arrow, blue_arrow], bbox_to_anchor=(0.45, 0), ncol=2)

green_arrow = mlines.Line2D(
    [],
    [],
    color="green",
    marker=">",
    linestyle="-",
    markersize=8,
    label=ax2_labels[0],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
blue_arrow = mlines.Line2D(
    [],
    [],
    color="blue",
    marker=">",
    linestyle="-",
    markersize=8,
    label=ax2_labels[1],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
fig.legend(handles=[green_arrow, blue_arrow], bbox_to_anchor=(0.85, 0), ncol=2)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("quiver_39.pdf", bbox_inches="tight")
