# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data for the plot (Media Domain)
regions_1 = ["Streaming", "Cable TV", "Social Media"]
viewer_statistics_1 = [65, 45, 85]  # Average viewer statistics in percentage
viewer_statistics_change_1 = [8, 3, 12]  # Change in viewer statistics in percentage
engagement_rate_1 = [55, 35, 70]  # Viewer engagement rate in percentage
engagement_rate_change_1 = [10, 5, 15]  # Change in engagement rate in percentage
ax1_labels = ["Viewer Stats Change (%)", "Engagement Rate Change (%)"]

regions_2 = ["Newspapers", "Podcasts", "Blogs"]
viewer_statistics_2 = [20, 30, 25]  # Average viewer statistics in percentage
viewer_statistics_change_2 = [2, 7, 4]  # Change in viewer statistics in percentage
engagement_rate_2 = [15, 45, 30]  # Viewer engagement rate in percentage
engagement_rate_change_2 = [3, 10, 6]  # Change in engagement rate in percentage
ax2_labels = ["Viewer Stats Change (%)", "Engagement Rate Change (%)"]

# Text labels
xlabel = "Percentage"
ylabel = "Media Categories"
title1 = "Media Consumption Trends (Group 1)"
title2 = "Media Consumption Trends (Group 2)"
supertitle = "Media Consumption and Engagement Trends"
legendlabels = ["Viewer Stats Change (%)", "Engagement Rate Change (%)"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure with two subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Set the y-axis offsets to be in the middle of each grid
offset = 0.5

# First subplot (regions_1)
for i, region in enumerate(regions_1):
    # Viewer Statistics change line with arrow and black dots at start and end
    ax1.annotate(
        "",
        xy=(viewer_statistics_1[i], i + offset * 3 / 2),
        xytext=(
            viewer_statistics_1[i] + viewer_statistics_change_1[i],
            i + offset * 3 / 2,
        ),
        arrowprops=dict(arrowstyle="<-", color="#FF5733"),  # Bright Orange
    )
    ax1.scatter(
        [
            viewer_statistics_1[i],
            viewer_statistics_1[i] + viewer_statistics_change_1[i],
        ],
        [i + offset * 3 / 2, i + offset * 3 / 2],
        color="black",
        s=25,
    )
    ax1.annotate(
        f"{viewer_statistics_change_1[i]:.2f}",
        (viewer_statistics_1[i] + viewer_statistics_change_1[i], i + offset * 1.75),
        color="#FF5733",
        ha="right",
        va="center",
    )

    # Engagement Rate change line with arrow and black dots at start and end
    ax1.annotate(
        "",
        xy=(engagement_rate_1[i], i + offset / 2),
        xytext=(engagement_rate_1[i] + engagement_rate_change_1[i], i + offset / 2),
        arrowprops=dict(arrowstyle="<-", color="#33C3F0"),  # Bright Blue
    )
    ax1.scatter(
        [engagement_rate_1[i], engagement_rate_1[i] + engagement_rate_change_1[i]],
        [i + offset / 2, i + offset / 2],
        color="black",
        s=25,
    )
    ax1.annotate(
        f"{engagement_rate_change_1[i]:.2f}",
        (engagement_rate_1[i] + engagement_rate_change_1[i], i + offset * 0.75),
        color="#33C3F0",
        ha="left",
        va="center",
    )

# Second subplot (regions_2)
for i, region in enumerate(regions_2):
    ax2.annotate(
        "",
        xy=(viewer_statistics_2[i], i + offset * 3 / 2),
        xytext=(
            viewer_statistics_2[i] + viewer_statistics_change_2[i],
            i + offset * 3 / 2,
        ),
        arrowprops=dict(arrowstyle="<-", color="#FF5733"),  # Bright Orange
    )
    ax2.scatter(
        [
            viewer_statistics_2[i],
            viewer_statistics_2[i] + viewer_statistics_change_2[i],
        ],
        [i + offset * 3 / 2, i + offset * 3 / 2],
        color="black",
        s=25,
    )
    ax2.annotate(
        f"{viewer_statistics_change_2[i]:.2f}",
        (viewer_statistics_2[i] + viewer_statistics_change_2[i], i + offset * 1.75),
        color="#FF5733",
        ha="right",
        va="center",
    )

    ax2.annotate(
        "",
        xy=(engagement_rate_2[i], i + offset / 2),
        xytext=(engagement_rate_2[i] + engagement_rate_change_2[i], i + offset / 2),
        arrowprops=dict(arrowstyle="<-", color="#33C3F0"),  # Bright Blue
    )
    ax2.scatter(
        [engagement_rate_2[i], engagement_rate_2[i] + engagement_rate_change_2[i]],
        [i + offset / 2, i + offset / 2],
        color="black",
        s=25,
    )
    ax2.annotate(
        f"{engagement_rate_change_2[i]:.2f}",
        (engagement_rate_2[i] + engagement_rate_change_2[i], i + offset * 0.75),
        color="#33C3F0",
        ha="left",
        va="center",
    )

# set y-axis limits
ax1.set_ylim(0, len(regions_1))
ax2.set_ylim(0, len(regions_2))

# Set x-axis limits uniformly
ax1.set_xlim(0, 100)
ax2.set_xlim(0, 100)

# Adjust the y-axis tick positions
ax1.set_yticks([i + offset for i in range(len(regions_1))])
ax1.set_yticklabels(regions_1)
ax2.set_yticks([i + offset for i in range(len(regions_2))])
ax2.set_yticklabels(regions_2)
ax2.yaxis.tick_right()
ax2.yaxis.set_label_position("right")

# Offset grid lines on the y-axis
ax1.set_yticks([i for i in range(len(regions_1))], minor=True)
ax2.set_yticks([i for i in range(len(regions_2))], minor=True)
ax1.yaxis.grid(True, which="minor", linewidth=0.5, alpha=0.7, color="grey")
ax2.yaxis.grid(True, which="minor", linewidth=0.5, alpha=0.7, color="grey")

# add x-axis grid lines and set gap is 10
ax1.xaxis.set_major_locator(plt.MultipleLocator(10))
ax2.xaxis.set_major_locator(plt.MultipleLocator(10))
ax1.grid(axis="x", linestyle="--", linewidth=0.5)
ax2.grid(axis="x", linestyle="--", linewidth=0.5)

# Create arrow-shaped legend entries with a line that aligns with the arrowhead
orange_arrow = mlines.Line2D(
    [],
    [],
    color="#FF5733",
    marker=">",
    linestyle="-",
    markersize=8,
    label=ax1_labels[0],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
blue_arrow = mlines.Line2D(
    [],
    [],
    color="#33C3F0",
    marker=">",
    linestyle="-",
    markersize=8,
    label=ax1_labels[1],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
fig.legend(handles=[orange_arrow, blue_arrow], bbox_to_anchor=(0.45, 0), ncol=2)

orange_arrow = mlines.Line2D(
    [],
    [],
    color="#FF5733",
    marker=">",
    linestyle="-",
    markersize=8,
    label=ax2_labels[0],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
blue_arrow = mlines.Line2D(
    [],
    [],
    color="#33C3F0",
    marker=">",
    linestyle="-",
    markersize=8,
    label=ax2_labels[1],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
fig.legend(handles=[orange_arrow, blue_arrow], bbox_to_anchor=(0.95, 0), ncol=2)

# Update plot titles and labels
ax1.set_title(title1)
ax2.set_title(title2)
fig.suptitle(supertitle, y=1.02)
fig.supxlabel(xlabel)
fig.supylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("quiver_46.pdf", bbox_inches="tight")
