# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
# Data for the plot
regions_1 = ["North America", "Europe", "Asia-Pacific"]
market_share_1 = [35, 50, 60]  # Smartphone market share in percentage
market_share_change_1 = [5, 7, 8]  # Change in smartphone market share
customer_satisfaction_1 = [80, 75, 82]  # Customer satisfaction with smartphones
customer_satisfaction_change_1 = [2, 3, 5]  # Change in customer satisfaction

regions_2 = ["South America", "Africa", "Middle East"]
market_share_2 = [25, 15, 40]  # Smartphone market share in percentage
market_share_change_2 = [4, 2, 6]  # Change in smartphone market share
customer_satisfaction_2 = [70, 65, 78]  # Customer satisfaction with smartphones
customer_satisfaction_change_2 = [3, 1, 4]  # Change in customer satisfaction

# Axis labels and legend labels
ax1_labels = ["Market Share Change (%)", "Customer Satisfaction Change (%)"]
ax2_labels = ["Market Share Change (%)", "Customer Satisfaction Change (%)"]

suptitle = "Smartphone Market Trends by Region"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure with two subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(14, 7))
offset = 0.5

# First subplot (regions_1)
for i, region in enumerate(regions_1):
    # Market Share change line with arrow and black dots at start and end
    ax1.annotate(
        "",
        xy=(market_share_1[i], i + offset * 3 / 2),
        xytext=(market_share_1[i] + market_share_change_1[i], i + offset * 3 / 2),
        arrowprops=dict(arrowstyle="<|-", color="green"),
    )
    ax1.scatter(
        [market_share_1[i], market_share_1[i] + market_share_change_1[i]],
        [i + offset * 3 / 2, i + offset * 3 / 2],
        color="green",
        s=50,
        edgecolor="black",
    )
    ax1.annotate(
        f"{market_share_change_1[i]:.2f}",
        (market_share_1[i] + market_share_change_1[i], i + offset * 1.75),
        color="green",
        ha="right",
        va="center",
    )

    # Customer Satisfaction change line with arrow and dots at start and end
    ax1.annotate(
        "",
        xy=(customer_satisfaction_1[i], i + offset / 2),
        xytext=(
            customer_satisfaction_1[i] + customer_satisfaction_change_1[i],
            i + offset / 2,
        ),
        arrowprops=dict(arrowstyle="<|-", color="purple"),
    )
    ax1.scatter(
        [
            customer_satisfaction_1[i],
            customer_satisfaction_1[i] + customer_satisfaction_change_1[i],
        ],
        [i + offset / 2, i + offset / 2],
        color="purple",
        s=50,
        edgecolor="black",
    )
    ax1.annotate(
        f"{customer_satisfaction_change_1[i]:.2f}",
        (
            customer_satisfaction_1[i] + customer_satisfaction_change_1[i],
            i + offset * 0.75,
        ),
        color="purple",
        ha="left",
        va="center",
    )

# Second subplot (regions_2)
for i, region in enumerate(regions_2):
    ax2.annotate(
        "",
        xy=(market_share_2[i], i + offset * 3 / 2),
        xytext=(market_share_2[i] + market_share_change_2[i], i + offset * 3 / 2),
        arrowprops=dict(arrowstyle="<|-", color="green"),
    )
    ax2.scatter(
        [market_share_2[i], market_share_2[i] + market_share_change_2[i]],
        [i + offset * 3 / 2, i + offset * 3 / 2],
        color="green",
        s=50,
        edgecolor="black",
    )
    ax2.annotate(
        f"{market_share_change_2[i]:.2f}",
        (market_share_2[i] + market_share_change_2[i], i + offset * 1.75),
        color="green",
        ha="right",
        va="center",
    )

    ax2.annotate(
        "",
        xy=(customer_satisfaction_2[i], i + offset / 2),
        xytext=(
            customer_satisfaction_2[i] + customer_satisfaction_change_2[i],
            i + offset / 2,
        ),
        arrowprops=dict(arrowstyle="<|-", color="purple"),
    )
    ax2.scatter(
        [
            customer_satisfaction_2[i],
            customer_satisfaction_2[i] + customer_satisfaction_change_2[i],
        ],
        [i + offset / 2, i + offset / 2],
        color="purple",
        s=50,
        edgecolor="black",
    )
    ax2.annotate(
        f"{customer_satisfaction_change_2[i]:.2f}",
        (
            customer_satisfaction_2[i] + customer_satisfaction_change_2[i],
            i + offset * 0.75,
        ),
        color="purple",
        ha="left",
        va="center",
    )

# Set y-axis limits
ax1.set_ylim(0, len(regions_1))
ax2.set_ylim(0, len(regions_2))

# Set x-axis limits uniformly
ax1.set_xlim(0, 100)
ax2.set_xlim(0, 100)

# Adjust the y-axis tick positions
ax1.set_yticks([i + offset for i in range(len(regions_1))])
ax1.set_yticklabels(regions_1)
ax2.set_yticks([i + offset for i in range(len(regions_2))])
ax2.set_yticklabels(regions_2)
ax2.yaxis.tick_right()
ax2.yaxis.set_label_position("right")

# Offset grid lines on the y-axis
ax1.set_yticks([i for i in range(len(regions_1))], minor=True)
ax2.set_yticks([i for i in range(len(regions_2))], minor=True)
ax1.yaxis.grid(True, which="minor", linewidth=0.5, alpha=0.7, color="grey")
ax2.yaxis.grid(True, which="minor", linewidth=0.5, alpha=0.7, color="grey")

# Add x-axis grid lines
ax1.xaxis.set_major_locator(plt.MultipleLocator(10))
ax2.xaxis.set_major_locator(plt.MultipleLocator(10))
ax1.grid(axis="x", linestyle="--", linewidth=0.5)
ax2.grid(axis="x", linestyle="--", linewidth=0.5)

# Create legend entries
green_arrow = mlines.Line2D(
    [],
    [],
    color="green",
    marker=">",
    linestyle="-",
    markersize=8,
    label=ax1_labels[0],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
purple_arrow = mlines.Line2D(
    [],
    [],
    color="purple",
    marker=">",
    linestyle="-",
    markersize=8,
    label=ax1_labels[1],
    linewidth=2,
    markeredgewidth=2,
    markevery=(1, 1),
)
fig.legend(
    handles=[green_arrow, purple_arrow],
    bbox_to_anchor=(0.70, 0.01),
    ncol=2,
    frameon=False,
)

# plt.subplots_adjust(bottom=0.15)
plt.suptitle(suptitle, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("quiver_47.pdf", bbox_inches="tight")
