# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np


# Define the political influence field function
def political_influence_field(X, Y):
    # Simplified political influence vector field
    U = np.sin(np.pi * X / 50) * np.cos(np.pi * Y / 50)
    V = -np.cos(np.pi * X / 50) * np.sin(np.pi * Y / 50)
    return U, V


# Create a grid of points
x = np.linspace(-50.0, 50.0, 20)
y = np.linspace(-50.0, 50.0, 20)
X, Y = np.meshgrid(x, y)

# Compute the political influence field
U, V = political_influence_field(X, Y)

# Labels and title
xlabel = "X Position (m)"
ylabel = "Y Position (m)"
title = "Political Influence Distribution"

annotation_text = "High Influence"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(8, 7))
ax.quiver(X, Y, U, V, color="navy", scale=50, width=0.003)

# Set labels and title
ax.set_xlabel(xlabel, fontsize=13)
ax.set_ylabel(ylabel, fontsize=13)
ax.set_title(title, fontsize=16, fontweight="bold")

# Set background color and grid
ax.set_facecolor("lightyellow")
ax.grid(True, linestyle="--", alpha=0.7, color="gray")

# Additional Annotations
ax.annotate(
    annotation_text,
    xy=(20, 20),
    xytext=(25, 25),
    arrowprops=dict(facecolor="black", shrink=0.05),
    fontsize=10,
    color="maroon",
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("quiver_54.pdf", bbox_inches="tight")
