# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np


# Define the wind field function for an entertainment domain (e.g., a theme park)
def wind_field(X, Y):
    # This is a simplified wind vector field in a theme park
    U = np.sin(np.pi * X / 25) * np.cos(np.pi * Y / 25)
    V = -np.cos(np.pi * X / 25) * np.sin(np.pi * Y / 25)
    return U, V


# Create a grid of points
x = np.linspace(-50.0, 50.0, 20)
y = np.linspace(-50.0, 50.0, 20)
X, Y = np.meshgrid(x, y)

# Compute the wind field
U, V = wind_field(X, Y)

# Set labels and title for the entertainment domain
xlabel = "X Coordinate (m)"
ylabel = "Y Coordinate (m)"
title = "Wind Field Distribution in Theme Park"

suptitle = "Theme Park Wind Analysis"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(8, 7))
ax.quiver(X, Y, U, V, color="mediumvioletred", scale=30, width=0.003)

# Set labels and title
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)
ax.set_title(title, fontsize=16, fontweight="bold")

# Set background color and grid
ax.set_facecolor("lemonchiffon")  # light yellow background
ax.grid(True, linestyle="--", alpha=0.6)

# Improve overall layout and aesthetics
fig.suptitle(suptitle, fontsize=18, fontweight="bold")
fig.subplots_adjust(top=0.88)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("quiver_56.pdf", bbox_inches="tight")
