
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

def network_data_flow(X, Y):
    # Simulate network data flow towards a central server
    U = -X * 0.3
    V = -Y * 0.3
    return U, V

# Create a grid of points
x = np.linspace(-50.0, 50.0, 25)
y = np.linspace(-50.0, 50.0, 25)
X, Y = np.meshgrid(x, y)

# Compute the vector field
U, V = network_data_flow(X, Y)
xlabel = "X Coordinate"
ylabel = "Y Coordinate"
title = "Network Data Flow: Traffic toward Central Server"
annotation_text = "Central Server"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(8, 7))
quiver = ax.quiver(
    X, Y, U, V, color="mediumseagreen", angles="xy", scale_units="xy", scale=0.6
)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title, fontsize=14, fontweight='bold')

# Grid and aspect ratio
ax.grid(True, linestyle="--", alpha=0.6)
ax.set_aspect("equal")

# Add annotations
ax.annotate(
    annotation_text,
    xy=(0, 0),
    xytext=(10, 10),
    color="darkred",
    fontsize=12,
    arrowprops=dict(color="darkred", arrowstyle="->", lw=2),
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("quiver_57.pdf", bbox_inches="tight")
