
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define the vector field function for ocean currents
def ocean_vector_field(X, Y):
    U = np.sin(np.pi * X / 100) * np.cos(np.pi * Y / 100)
    V = -np.cos(np.pi * X / 100) * np.sin(np.pi * Y / 100)
    return U, V

# Create a grid of points
x = np.linspace(-100.0, 100.0, 20)
y = np.linspace(-100.0, 100.0, 20)
X, Y = np.meshgrid(x, y)

# Compute the vector field for ocean currents
U, V = ocean_vector_field(X, Y)
speed = np.sqrt(U**2 + V**2)

xlabel = "Longitude (degrees)"
ylabel = "Latitude (degrees)"
title = "Simulated Ocean Currents"
cbar_label = "Current Speed (m/s)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(10, 8))
Q = ax.quiver(X, Y, U, V, speed, cmap="Blues", alpha=0.9, scale=50)

# Set labels and title
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14, fontweight='bold')

# Show grid
ax.grid(True, linestyle='dotted', color='gray', alpha=0.7)

# Add a color bar
cbar = fig.colorbar(Q, ax=ax, orientation='vertical')
cbar.set_label(cbar_label, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("quiver_63.pdf", bbox_inches="tight")
