
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define the vector field function for water currents
def water_vector_field(X, Y):
    U = np.sin(np.pi * X) * np.cos(np.pi * Y)
    V = -np.cos(np.pi * X) * np.sin(np.pi * Y)
    return U, V

# Create a grid of points
x = np.linspace(-50.0, 50.0, 20)
y = np.linspace(-50.0, 50.0, 20)
X, Y = np.meshgrid(x, y)

# Compute the vector field for water currents
U, V = water_vector_field(X, Y)
speed = np.sqrt(U**2 + V**2)

# Text labels
xlabel = "X Coordinate (m)"
ylabel = "Y Coordinate (m)"
title = "Simulated Water Currents in a Lake"
cbar_label = "Current Speed (m/s)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(8, 6))
Q = ax.quiver(X, Y, U, V, speed, cmap="viridis", alpha=0.9)

# Set labels and title
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14)

# Show grid
ax.grid(True, linestyle="--", alpha=0.6)

# Add a color bar
cbar = fig.colorbar(Q, ax=ax)
cbar.set_label(cbar_label, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("quiver_65.pdf", bbox_inches="tight")
