
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Define the vector field function for people's movements
def movement_vector_field(X, Y):
    # Hypothetical function representing people's movement in a public square
    U = - np.sin(Y)
    V = np.cos(X)
    return U, V

# Create a grid of points representing the public square
x = np.linspace(-10.0, 10.0, 30)
y = np.linspace(-10.0, 10.0, 30)
X, Y = np.meshgrid(x, y)

# Compute the vector field
U, V = movement_vector_field(X, Y)
xlabel = "X Coordinate (meters)"
ylabel = "Y Coordinate (meters)"
title = "Movement Patterns in a Public Square"
cbar_label = "Movement Intensity"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(10, 8))

# Use a warm color scheme to reflect the social theme
colors = np.sqrt(U**2 + V**2)
quiver = ax.quiver(X, Y, U, V, colors, cmap="autumn")

# Add several streamlines to the vector field plot for better visualization
strm = ax.streamplot(X, Y, U, V, color="brown", linewidth=0.7)

# Set labels and title
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=16, pad=15)

# Show grid
ax.grid(True, linestyle="--", alpha=0.7)

# Add color bar
cbar = plt.colorbar(quiver, ax=ax)
cbar.set_label(cbar_label, rotation=270, labelpad=15)

# Adjust the aspect ratio
ax.set_aspect("equal")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Display the plot
plt.savefig("quiver_72.pdf", bbox_inches="tight")
