
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define the vector field function for ocean currents
def vector_field(X, Y):
    # Simulated ocean current pattern
    U = np.cos(np.pi * X / 5) * np.sin(np.pi * Y / 5)
    V = np.sin(np.pi * X / 5) * np.cos(np.pi * Y / 5)
    return U, V

# Create a finer grid of points
x = np.linspace(-5.0, 5.0, 20)
y = np.linspace(-5.0, 5.0, 20)
X, Y = np.meshgrid(x, y)

# Compute the vector field
U, V = vector_field(X, Y)
xlabel = "Longitude"
ylabel = "Latitude"
title = "Simulated Ocean Current Patterns"
colorbar_title = "Current Magnitude (m/s)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(8, 6))

# Use a color scheme appropriate for ocean currents
colors = np.sqrt(U**2 + V**2)
quiver = ax.quiver(X, Y, U, V, colors, cmap="viridis")

# Add several streamlines to the vector field plot
strm = ax.streamplot(X, Y, U, V, color="navy", linewidth=0.5, density=1.2)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Show grid, set grid style
ax.grid(True, linestyle="--", alpha=0.7)

# Adjust the aspect ratio
ax.set_aspect("equal")

# Add color bar to indicate the magnitude of the vectors
cbar = plt.colorbar(quiver, ax=ax)
cbar.set_label(colorbar_title)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

# Display the plot
plt.savefig("quiver_75.pdf", bbox_inches="tight")

