
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

def ocean_currents(X, Y):
    # Simulating an ocean current pattern
    U = np.sin(Y / 2) - np.cos(X / 2)
    V = np.sin(X / 2) + np.cos(Y / 2)
    return U, V

# Create a grid of points
x = np.linspace(-5.0, 5.0, 20)
y = np.linspace(-5.0, 5.0, 20)
X, Y = np.meshgrid(x, y)

# Compute the ocean current vector field
U, V = ocean_currents(X, Y)
magnitude = np.sqrt(U**2 + V**2)

xlabel = "Longitude (degrees)"
ylabel = "Latitude (degrees)"
title = "Simulated Ocean Currents"
colorbar_title = "Current Magnitude (m/s)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(10, 8))
quiver = ax.quiver(X, Y, U, V, magnitude, cmap="ocean", scale=5, headwidth=3, headlength=4)

# Set labels and title
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=16, weight='bold')

# Show grid with oceanic style
ax.grid(True, linestyle="--", alpha=0.5, color='grey')

# Add color bar to show magnitude
cbar = plt.colorbar(quiver, ax=ax)
cbar.set_label(colorbar_title, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("quiver_78.pdf", bbox_inches="tight")
