
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

def market_forces(X, Y):
    # Simulating market forces affecting product categories
    U = 0.5 * Y - 1.5
    V = -0.7 * X + 2.0
    return U, V

# Create a grid of points
x = np.linspace(-3.0, 10.0, 10)
y = np.linspace(-3.0, 10.0, 10)
X, Y = np.meshgrid(x, y)

# Compute the market forces vector field
U, V = market_forces(X, Y)
magnitude = np.sqrt(U**2 + V**2)

xlabel = "Market Position (X)"
ylabel = "Market Position (Y)"
title = "Market Forces Vector Field"
colorbar_title = "Force Magnitude"
suptitle = "Vector Field Indicating Market Forces on Product Categories"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(10, 8))
quiver = ax.quiver(X, Y, U, V, magnitude, cmap="coolwarm", scale=5, pivot='mid')

# Set labels and title
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14)
fig.suptitle(suptitle, fontsize=16, y=1.02)

# Show grid
ax.grid(True, linestyle="--", alpha=0.7)

# Add color bar to show magnitude
cbar = plt.colorbar(quiver, ax=ax)
cbar.set_label(colorbar_title, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("quiver_79.pdf", bbox_inches="tight")
