
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.lines import Line2D

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Domain-specific data: Performance Metrics for two fictional soccer players
values_player_a = [8.5, 7.0, 9.0, 6.0, 8.0, 7.5]
values_player_b = [7.0, 6.5, 6.0, 8.0, 7.5, 8.5]
num_vars = len(values_player_a)
labels = ["Player A", "Player B"]
metric_labels = ["Dribbling", "Passing", "Shooting", "Defense", "Speed", "Stamina"]
ticks = [2, 4, 6, 8, 10]
tickslabel = ["2", "4", "6", "8", "10"]
title = "Performance Metrics of Soccer Players"

# Extend data to close the radar chart loop
values_player_a += values_player_a[:1]
values_player_b += values_player_b[:1]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()
angles += angles[:1]

# Draw the radar chart
fig, ax = plt.subplots(figsize=(8, 8), subplot_kw=dict(polar=True))

# Fill and plot Player A's performance
ax.fill(angles, values_player_a, color="blue", alpha=0.1)
ax.plot(angles, values_player_a, color="blue", linewidth=2, linestyle='solid', label=labels[0])
ax.scatter(angles[:-1], values_player_a[:-1], color="blue", s=50, marker='o')

# Fill and plot Player B's performance
ax.fill(angles, values_player_b, color="green", alpha=0.1)
ax.plot(angles, values_player_b, color="green", linewidth=2, linestyle='dashed', label=labels[1])
ax.scatter(angles[:-1], values_player_b[:-1], color="green", s=50, marker='s')

# Add labels to the plot
ax.set_yticklabels([])
ax.set_xticks(angles[:-1])
ax.set_xticklabels(metric_labels, size=12, color="gray")

# Add grid lines and labels for the concentric circles
ax.set_rgrids(
    ticks,
    labels=tickslabel,
    angle=30,
    color="gray",
    size=10,
)

# Create legend handles manually
legend_elements = [
    Line2D([0], [0], color="blue", linewidth=2, linestyle='solid', marker='o', markersize=8, label=labels[0]),
    Line2D([0], [0], color="green", linewidth=2, linestyle='dashed', marker='s', markersize=8, label=labels[1]),
]

# Add legend and title
ax.legend(handles=legend_elements, loc="upper right", bbox_to_anchor=(1.1, 1.1), frameon=False)
ax.set_title(title, size=16, color="black", pad=20)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("radar_27.pdf", bbox_inches="tight")
