# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Define the data for each book/genre
labels = np.array(
    [
        "Character Development",
        "Plot Complexity",
        "Narrative Style",
        "Historical Accuracy",
        "Reader Engagement",
    ]
)
stats = np.array([[4, 3, 5, 4, 3], [2, 4, 3, 5, 4], [5, 2, 4, 3, 5]])
titles = ["Classic Novel", "Historical Fiction", "Modern Thriller"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
fig, ax = plt.subplots(figsize=(12, 8), nrows=1, ncols=3, subplot_kw=dict(polar=True))

# Colors suitable for a literature theme
colors = ["#8B4513", "#4682B4", "#228B22"]

# Define the number of variables
num_vars = len(labels)
# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()
# The plot is made circular
stats = np.concatenate((stats, stats[:, [0]]), axis=1)
angles += angles[:1]

# Draw one radar chart for each book/genre
for idx, (title, case_data, color) in enumerate(zip(titles, stats, colors)):
    # Plot the data
    ax[idx].plot(
        angles, case_data, color=color, linewidth=2, linestyle="--", marker="o"
    )
    ax[idx].fill(angles, case_data, color=color, alpha=0.25)
    ax[idx].set_yticks([1, 2, 3, 4, 5])
    ax[idx].set_yticklabels(["1", "2", "3", "4", "5"], color="gray", size=10)
    ax[idx].set_xticks(angles[:-1])
    ax[idx].set_xticklabels(labels, color="black", size=11)
    ax[idx].set_title(title, size=14, color="black", position=(0.5, -0.1))

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit
plt.tight_layout()

# Show the plot
plt.savefig("radar_32.pdf", bbox_inches="tight")
