
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data for the radar chart
labels = np.array(
    [
        "[1] Crop Yield",
        "[2] Soil Quality",
        "[3] Water Availability",
        "[4] Pest Resistance",
        "[5] Climate Adaptability",
        "[6] Nutrient Absorption",
        "[7] Harvest Frequency",
        "[8] Market Value",
        "[9] Disease Resistance",
        "[10] Growth Rate",
    ]
)
baseline_values = np.array([70, 85, 80, 65, 90, 75, 70, 80, 85, 95])
new_tech_values = np.array([85, 90, 75, 80, 95, 85, 75, 90, 90, 100])
yticks = [20, 40, 60, 80, 100]
ytickslabel = ["20", "40", "60", "80", "100"]
ylim = [0, 120]
labels2 = ["Traditional Methods", "New Technology"]
rgrids = [40, 60, 80, 100]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Size of the figure

fig, ax = plt.subplots(figsize=(8, 8), subplot_kw=dict(polar=True))

# Number of variables
num_vars = len(labels)

# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()

# The plot is circular, so we need to "complete the loop" and append the start to the end.
baseline_values = np.concatenate((baseline_values, [baseline_values[0]]))
new_tech_values = np.concatenate((new_tech_values, [new_tech_values[0]]))
angles += angles[:1]

# Draw one axe per variable and add labels
plt.xticks(angles[:-1], [], color="black", size=8, ha="right")
for angle, label in zip(angles[:-1], labels):  # Remove the appended first element
    if (
        angle < np.pi / 2 or angle > 3 * np.pi / 2
    ):  # If the text is at the bottom or right side of the chart
        ax.text(
            angle,
            125,
            label,
            horizontalalignment="left",
            size=8,
            verticalalignment="bottom",
        )
    else:  # If the text is at the top or left side of the chart
        ax.text(
            angle,
            125,
            label,
            horizontalalignment="right",
            size=8,
            verticalalignment="bottom",
        )

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(
    yticks,
    ytickslabel,
    color="grey",
    size=8,
)
plt.ylim(ylim)

# Plot data
ax.plot(
    angles,
    baseline_values,
    linewidth=1,
    linestyle="dashed",
    label=labels2[0],
    color="brown",
    marker='o',
    markersize=5,
)
ax.fill(angles, baseline_values, "brown", alpha=0.1)

ax.plot(
    angles,
    new_tech_values,
    linewidth=2,
    linestyle="solid",
    label=labels2[1],
    color="green",
    marker='s',
    markersize=5,
)
ax.fill(angles, new_tech_values, "green", alpha=0.1)

# Add legend
plt.legend(loc="upper right", bbox_to_anchor=(0.1, 0.1))

# Adjust gridlines
ax.set_rgrids(
    rgrids,
    labels=rgrids,
    angle=0,
    color="black",
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_34.pdf", bbox_inches="tight")
