# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from math import pi

# ===================
# Part 2: Data Preparation and Text Parameters
# ===================
import numpy as np

np.random.seed(42)
# Define the data for each line
values_approval = [0.65, 0.70, 0.68, 0.72, 0.66, 0.69]
values_trust = [0.60, 0.62, 0.61, 0.64, 0.58, 0.63]
values_debate = [0.55, 0.50, 0.53, 0.58, 0.56, 0.52]
values_policy = [0.72, 0.75, 0.70, 0.74, 0.78, 0.73]
xtickslabel = [
    "Candidate_A",
    "Candidate_B",
    "Candidate_C",
    "Candidate_D",
    "Candidate_E",
    "Candidate_F",
]
y_ticks = [0.5, 0.6, 0.7, 0.8]
labels = [
    "Approval Ratings",
    "Trustworthiness",
    "Debate Performance",
    "Policy Knowledge",
]
ylim = [0.5, 0.85]

# Labels for y axis
y_labels_custom_1 = ["0.55"] * len(xtickslabel)
y_labels_custom_2 = ["0.65"] * len(xtickslabel)

title = "Political Candidates' Performance Metrics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set up the figure and polar axis
fig, ax = plt.subplots(figsize=(8, 8), subplot_kw=dict(polar=True))

# Number of variables
num_vars = len(values_approval)
# Compute angle for each axis
angles = [n / float(num_vars) * 2 * pi for n in range(num_vars)]
angles += angles[:1]  # Complete the loop

# Repeat the first value to close the circle
values_approval += values_approval[:1]
values_trust += values_trust[:1]
values_debate += values_debate[:1]
values_policy += values_policy[:1]

# Draw one axe per variable and add labels
plt.xticks(
    angles[:-1],
    xtickslabel,
    color="black",
    size=10,
)


# # Draw ylabels
# def add_custom_y_labels(ax, angles, labels, distance, size=9):
#     for angle, label in zip(angles, labels):
#         ax.text(
#             angle,
#             distance,
#             label,
#             horizontalalignment="center",
#             size=size,
#             verticalalignment="bottom",
#         )


# Define the range of y-axis and y-labels
plt.yticks(y_ticks, [str(i) for i in y_ticks], color="black", size=10)
# add_custom_y_labels(ax, angles[:-1], y_labels_custom_1, 0.55)
# add_custom_y_labels(ax, angles[:-1], y_labels_custom_2, 0.65)

# Set y-axis limit
plt.ylim(ylim)

# Plot data and fill area for each line
colors = ["navy", "gold", "teal", "crimson"]

ax.plot(
    angles,
    values_approval,
    linewidth=2,
    linestyle="solid",
    label=labels[0],
    color=colors[0],
    marker="o",
)
ax.fill(angles, values_approval, colors[0], alpha=0.1)

ax.plot(
    angles,
    values_trust,
    linewidth=2,
    linestyle="dashed",
    label=labels[1],
    color=colors[1],
    marker="s",
)
ax.fill(angles, values_trust, colors[1], alpha=0.1)

ax.plot(
    angles,
    values_debate,
    linewidth=2,
    linestyle="dashdot",
    label=labels[2],
    color=colors[2],
    marker="^",
)
ax.fill(angles, values_debate, colors[2], alpha=0.1)

ax.plot(
    angles,
    values_policy,
    linewidth=2,
    linestyle="dotted",
    label=labels[3],
    color=colors[3],
    marker="D",
)
ax.fill(angles, values_policy, colors[3], alpha=0.1)

# Add legend with a different style
plt.legend(loc="lower center", bbox_to_anchor=(0.5, -0.25), ncol=2)

# Title
plt.title(title, size=15, color="black", position=(0.5, 1.1))

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_37.pdf", bbox_inches="tight")
