
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for each franchise
labels = np.array(
    [
        "Box Office\nPerformance",
        "Critical\nAcclaim",
        "Fan\nEngagement",
        "Streaming\nPopularity",
        "Merchandise\nSales",
    ]
)
stats_franchise_a = np.array([85, 60, 90, 75, 80])
stats_franchise_b = np.array([70, 80, 85, 65, 70])
stats_franchise_c = np.array([75, 70, 60, 85, 75])

# Number of variables
num_vars = len(labels)

# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()

# The plot is made circular, so we need to "complete the loop" and append the start to the end.
stats_franchise_a = np.concatenate((stats_franchise_a, [stats_franchise_a[0]]))
stats_franchise_b = np.concatenate((stats_franchise_b, [stats_franchise_b[0]]))
stats_franchise_c = np.concatenate((stats_franchise_c, [stats_franchise_c[0]]))
angles += angles[:1]

# Extracted variables
label_franchise_a = "Franchise A"
label_franchise_b = "Franchise B"
label_franchise_c = "Franchise C"
xlim_values = None  # Not specified in the code
ylim_values = (0, 100)
xlabel_value = None  # Not specified in the code
ylabel_value = None  # Not specified in the code
xticks_values = angles[:-1]
yticks_values = [20, 40, 60, 80]
xtickslabel_values = labels
ytickslabel_values = []  # Empty list as specified in plt.yticks
title_value = "Franchise Performance Radar Chart"
axhline_value = None  # Not specified in the code
axvline_value = None  # Not specified in the code

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Size of the figure
fig, ax = plt.subplots(figsize=(6, 6), subplot_kw=dict(polar=True))

# Draw one axe per variable and add labels with increased padding
plt.xticks(xticks_values, xtickslabel_values)
ax.tick_params(pad=15)  # Increase the distance of the label from the axis

# Draw ylabels and set them to be dashed
ax.set_rlabel_position(0)
plt.yticks(yticks_values, ytickslabel_values, color="grey", size=8)
plt.ylim(ylim_values)

# Customizing the grid (set grid to be dashed)
ax.yaxis.grid(True, linestyle="--", color="grey", linewidth=0.5)

# Plot data
ax.plot(
    angles,
    stats_franchise_a,
    color="orange",
    linewidth=2,
    linestyle="solid",
    marker='o',
    markersize=5,
    label=label_franchise_a,
)
ax.fill(angles, stats_franchise_a, color="orange", alpha=0.25)

ax.plot(
    angles,
    stats_franchise_b,
    color="purple",
    linewidth=2,
    linestyle="dashed",
    marker='s',
    markersize=5,
    label=label_franchise_b,
)
ax.fill(angles, stats_franchise_b, color="purple", alpha=0.25)

ax.plot(
    angles,
    stats_franchise_c,
    color="teal",
    linewidth=2,
    linestyle="dotted",
    marker='^',
    markersize=5,
    label=label_franchise_c,
)
ax.fill(angles, stats_franchise_c, color="teal", alpha=0.25)

# Add title
plt.title(title_value, size=15, color='black', y=1.1)

# Add legend
plt.legend(loc="lower center", bbox_to_anchor=(0.5, -0.2), ncol=3, frameon=False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit
plt.tight_layout()

# Show the plot
plt.savefig("radar_42.pdf", bbox_inches="tight")
