# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Seed for reproducibility
np.random.seed(0)

# Data Categories and Values
categories = [
    "Accommodation",
    "Food",
    "Transport",
    "Activities",
    "Shopping",
    "Entertainment",
]
values1 = [85, 78, 92, 80, 75, 88]
values2 = [40, 42, 45, 45, 40, 40]
labels = ["Region A", "Region B"]

# Labels and Title
xlabel = "Tourism Factors"
ylabel = "Scores"
title = "Tourism Satisfaction Comparison"
annotation_offset = 5

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Number of variables
num_vars = len(categories)

# Compute angle for each category
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()

# The plot is circular, so we need to "complete the loop" and append the start to the end.
values1 += values1[:1]
values2 += values2[:1]
angles += angles[:1]

# Plot
fig, ax = plt.subplots(figsize=(8, 7), subplot_kw=dict(polar=True))
ax.fill(angles, values1, color="#66c2a5", alpha=0.25)
ax.fill(angles, values2, color="#fc8d62", alpha=0.25)
ax.plot(
    angles,
    values1,
    color="#66c2a5",
    linewidth=2,
    label=labels[0],
    linestyle="-",
    marker="o",
)
ax.plot(
    angles,
    values2,
    color="#fc8d62",
    linewidth=2,
    label=labels[1],
    linestyle="--",
    marker="s",
)

# Labels and annotations for each point
for angle, value1, value2 in zip(angles[:-1], values1[:-1], values2[:-1]):
    ax.annotate(
        f"{value1}",
        xy=(angle, value1),
        xytext=(annotation_offset, annotation_offset),
        textcoords="offset points",
    )
    ax.annotate(
        f"{value2}",
        xy=(angle, value2),
        xytext=(annotation_offset, -annotation_offset),
        textcoords="offset points",
    )

# Labels for each point
ax.set_xticks(angles[:-1])
ax.set_xticklabels(categories)

# Remove ylabels
ax.set_yticklabels([])

# Title
plt.title(title, size=15, color="#444444", pad=20)

# Legend
ax.legend(
    loc="lower center",
    bbox_to_anchor=(0.5, -0.1),
    ncol=2,
    frameon=True,
    facecolor="#f2f2f2",
    edgecolor="#f2f2f2",
)

ax.xaxis.set_tick_params(pad=25)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_46.pdf", bbox_inches="tight")
