# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
from math import pi

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Define the data for the radar chart
categories = [
    "Fuel Efficiency",
    "Safety",
    "Comfort",
    "Speed",
    "Cost",
    "Environmental Impact",
]
N = len(categories)

# Values for each transportation mode
Electric_Car = [85, 90, 75, 80, 70, 95]
Bicycle = [60, 60, 60, 60, 65, 65]
Train = [45, 40, 40, 45, 45, 40]

labels = ["Electric Car", "Bicycle", "Train"]
title = "Transportation Mode Comparison\n(speed-up ratio: 3)"
yticks = [20, 40, 60, 80]
ylim = [0, 100]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Initialize the spider plot
fig, ax = plt.subplots(figsize=(6, 6), subplot_kw=dict(polar=True))

# We need to repeat the first value to close the circular graph:
Electric_Car += Electric_Car[:1]
Bicycle += Bicycle[:1]
Train += Train[:1]

# Calculate angle for each category
angles = [n / float(N) * 2 * pi for n in range(N)]
angles += angles[:1]

# Draw one axe per variable and add labels
plt.xticks(angles[:-1], categories)

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(yticks, color="grey", size=10)
plt.ylim(ylim)

# Plot data
ax.plot(
    angles,
    Electric_Car,
    linewidth=2,
    linestyle="solid",
    label=labels[0],
    color="#1f77b4",
    marker="o",
)
ax.plot(
    angles,
    Bicycle,
    linewidth=2,
    linestyle="dashed",
    label=labels[1],
    color="#ff7f0e",
    marker="s",
)
ax.plot(
    angles,
    Train,
    linewidth=2,
    linestyle="dotted",
    label=labels[2],
    color="#2ca02c",
    marker="^",
)

# Add a title and a legend
plt.title(title, size=15, color="black", y=1.1)
plt.legend(loc="upper left", bbox_to_anchor=(0.9, 1.0))

ax.xaxis.set_tick_params(pad=30)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_48.pdf", bbox_inches="tight")
