
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Simulate the new business performance metrics data
labels = np.array(
    [
        "Sales",
        "Marketing",
        "Customer Satisfaction",
        "R&D",
        "Employee Satisfaction",
        "Profitability",
        "Market Share",
    ]
)
stats_company_a = np.array([0.8, 0.6, 0.7, 0.5, 0.9, 0.6, 0.8])
stats_company_b = np.array([0.7, 0.9, 0.6, 0.8, 0.7, 0.6, 0.7])
xticks = [0.2, 0.4, 0.6, 0.8]
xtickslabel = ["0.2", "0.4", "0.6", "0.8"]
label_a = "Company A"
label_b = "Company B"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(6, 6), subplot_kw=dict(polar=True))

# Number of variables
num_vars = len(labels)

# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()

# The plot is circular, so we need to "complete the loop" and append the start to the end.
stats_company_a = np.concatenate((stats_company_a, [stats_company_a[0]]))
stats_company_b = np.concatenate((stats_company_b, [stats_company_b[0]]))
angles += angles[:1]

# Draw one axe per variable and add labels
plt.xticks(angles[:-1], labels, color="black", size=10)
ax.tick_params(pad=20)  # Increase the distance of the label from the axis

# Draw ylabels
ax.set_rscale("linear")
plt.yticks(xticks, xtickslabel, color="grey", size=7)
plt.ylim(0, 1)

# Plot data for Company A
ax.plot(
    angles,
    stats_company_a,
    linewidth=2,
    linestyle="-",
    label=label_a,
    marker="o",
    color="#1f77b4",
)

# Plot data for Company B
ax.plot(
    angles,
    stats_company_b,
    linewidth=2,
    linestyle="--",
    label=label_b,
    marker="s",
    color="#ff7f0e",
)

# Add legend
plt.legend(loc="lower center", bbox_to_anchor=(0.5, -0.2), ncol=2)

# Add chart title
plt.title("Business Performance Metrics Comparison", size=14, color='black')

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_58.pdf", bbox_inches="tight")
