# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Labels for the new domain: Technology
labels = np.array(
    ["Network", "Database", "Security", "Cloud", "AI/ML", "Hardware", "Software", "IoT"]
)
Tech_A = np.array([0.85, 0.75, 0.9, 0.7, 0.95, 0.6, 0.8, 0.9])
Tech_B = np.array([0.6, 0.7, 0.65, 0.8, 0.75, 0.7, 0.6, 0.65])
Tech_C = np.array([0.75, 0.6, 0.7, 0.85, 0.8, 0.75, 0.85, 0.7])
Tech_D = np.array([0.9, 0.85, 0.8, 0.9, 0.9, 0.8, 0.85, 0.95])
yticks = [0.2, 0.4, 0.6, 0.8]
legend_labels = ["Tech_A", "Tech_B", "Tech_C", "Tech_D"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(6, 6), subplot_kw=dict(polar=True))

# Number of variables
num_vars = len(labels)

# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()

# Complete the loop for radar chart continuity
Tech_A = np.concatenate((Tech_A, [Tech_A[0]]))
Tech_B = np.concatenate((Tech_B, [Tech_B[0]]))
Tech_C = np.concatenate((Tech_C, [Tech_C[0]]))
Tech_D = np.concatenate((Tech_D, [Tech_D[0]]))
angles += angles[:1]

# Draw axis per variable and add labels
plt.xticks(angles[:-1], labels, color="black", size=10)
ax.tick_params(pad=10)  # Increase distance of label from axis

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(yticks, [], color="grey", size=7)
plt.ylim(0, 1)

# Plot data
ax.plot(
    angles,
    Tech_A,
    color="#FF6347",
    linewidth=2,
    linestyle="solid",
    label=legend_labels[0],
    marker="s",
)
ax.plot(
    angles,
    Tech_B,
    color="#4682B4",
    linewidth=2,
    linestyle="dashed",
    label=legend_labels[1],
    marker="^",
)
ax.plot(
    angles,
    Tech_C,
    color="#8A2BE2",
    linewidth=2,
    linestyle="dashdot",
    label=legend_labels[2],
    marker="o",
)
ax.plot(
    angles,
    Tech_D,
    color="#3CB371",
    linewidth=2,
    linestyle="dotted",
    label=legend_labels[3],
    marker="D",
)

# Add legend
plt.legend(loc="upper left", bbox_to_anchor=(1, 1))

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit and save the plot
plt.tight_layout()
plt.savefig("radar_61.pdf", bbox_inches="tight")
