# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
from math import pi

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define the data for each environmental indicator
air_quality = [82, 85, 85, 80, 80]  # Air Quality Index
water_quality = [60, 75, 70, 75, 75]  # Water Quality Index
forest_cover = [40, 50, 55, 50, 50]  # Forest Cover Percentage
xtickslabel = ["North\nAmerica", "Europe", "Asia", "Africa", "South\nAmerica"]
yticks = [20, 40, 60, 80, 100]
ytickslabel = ["20", "40", "60", "80", "100"]
ylim = [0, 100]
xlabel = "Regions"
ylabel = "Index/Percentage"
labels = ["Air Quality Index", "Water Quality Index", "Forest Cover Percentage"]
chart_title = "Environmental Indicators by Region"

# Number of variables
num_vars = len(air_quality)

# Compute angle for each axis
angles = [n / float(num_vars) * 2 * pi for n in range(num_vars)]
angles += angles[:1]  # Complete the loop

# Repeat the first value to close the circle
air_quality += air_quality[:1]
water_quality += water_quality[:1]
forest_cover += forest_cover[:1]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Initialize the spider plot
fig, ax = plt.subplots(figsize=(8, 7), subplot_kw=dict(polar=True))

# Draw one axe per variable and add labels
plt.xticks(angles[:-1], xtickslabel, size=10)

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(yticks, ytickslabel, color="grey", size=7)
plt.ylim(ylim)

# Plot each environmental indicator
ax.plot(
    angles,
    air_quality,
    linewidth=2,
    linestyle="solid",
    label=labels[0],
    color="mediumseagreen",
    marker="o",
)
ax.fill(angles, air_quality, "mediumseagreen", alpha=0.1)

ax.plot(
    angles,
    water_quality,
    linewidth=2,
    linestyle="dashed",
    label=labels[1],
    color="deepskyblue",
    marker="s",
)
ax.fill(angles, water_quality, "deepskyblue", alpha=0.1)

ax.plot(
    angles,
    forest_cover,
    linewidth=2,
    linestyle="dashdot",
    label=labels[2],
    color="darkolivegreen",
    marker="^",
)
ax.fill(angles, forest_cover, "darkolivegreen", alpha=0.1)


# Add a legend to the upper right
plt.legend(loc="lower center", bbox_to_anchor=(0.5, -0.2), ncol=3)

# Add chart title
plt.title(chart_title, size=15, color="darkslategrey")
ax.xaxis.set_tick_params(pad=20)

# ===================
# Part 4: Saving Output
# ===================
# Adjust figure size to match original image's dimensions
fig.set_size_inches(8, 7)

# Adjust layout
plt.tight_layout()

plt.savefig("radar_66.pdf", bbox_inches="tight")
