# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from math import pi

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define the data for each region
values1 = [333.0, 332.0, 331.0, 334.0, 335.0]  # USA
values2 = [748.0, 746.0, 745.0, 747.0, 746.0]  # Europe
values3 = [1400.0, 1399.0, 1401.0, 1402.0, 1403.0]  # China
xtickslabel = ["2018", "2019", "2020", "2021", "2022"]
yticks = [200, 600, 1000, 1400]
ytickslabel = ["200", "600", "1000", "1400"]
ylim = [0, 1500]
labels = ["USA", "Europe", "China"]

title = "Population Distribution in Different Regions"

# Number of variables
num_vars = len(values1)

# Compute angle for each axis
angles = [n / float(num_vars) * 2 * pi for n in range(num_vars)]
angles += angles[:1]  # Complete the loop

# Repeat the first value to close the circle
values1 += values1[:1]
values2 += values2[:1]
values3 += values3[:1]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Initialize the spider plot
fig, ax = plt.subplots(figsize=(8, 7), subplot_kw=dict(polar=True))

# Draw one axe per variable and add labels
plt.xticks(angles[:-1], xtickslabel, size=12)

# Draw ylabels
ax.set_rlabel_position(0)
plt.yticks(yticks, ytickslabel, color="grey", size=10)
plt.ylim(ylim)

# Plot each region
ax.plot(
    angles,
    values1,
    linewidth=1.5,
    linestyle="--",
    marker="o",
    markersize=5,
    label=labels[0],
    color="#FF5733",
)
ax.fill(angles, values1, "#FF5733", alpha=0.1)

ax.plot(
    angles,
    values2,
    linewidth=1.5,
    linestyle="--",
    marker="o",
    markersize=5,
    label=labels[1],
    color="#33FF57",
)
ax.fill(angles, values2, "#33FF57", alpha=0.1)

ax.plot(
    angles,
    values3,
    linewidth=1.5,
    linestyle="--",
    marker="o",
    markersize=5,
    label=labels[2],
    color="#3357FF",
)
ax.fill(angles, values3, "#3357FF", alpha=0.1)

# Add data points labels
for i in range(num_vars):
    # For USA values
    ax.annotate(
        f"{values1[i]}",
        xy=(angles[i], values1[i]),
        xytext=(5, 5),
        textcoords="offset points",
        ha="right",
        va="bottom",
        size=8,
        color="#FF5733",
    )

    # For Europe values
    ax.annotate(
        f"{values2[i]}",
        xy=(angles[i], values2[i]),
        xytext=(5, 5),
        textcoords="offset points",
        ha="right",
        va="bottom",
        size=8,
        color="#33FF57",
    )

    # For China values
    ax.annotate(
        f"{values3[i]}",
        xy=(angles[i], values3[i]),
        xytext=(5, 5),
        textcoords="offset points",
        ha="right",
        va="bottom",
        size=8,
        color="#3357FF",
    )

# Add a legend to the upper right
plt.legend(loc="upper right", bbox_to_anchor=(1.15, 1.15), fontsize=10)

# Add title
plt.title(title, size=15, weight="bold", pad=20)

# ===================
# Part 4: Saving Output
# ===================
# Adjust figure size to match original image's dimensions
fig.set_size_inches(8, 7)

# Adjust layout
plt.tight_layout()

plt.savefig("radar_67.pdf", bbox_inches="tight")
