
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Define the new data for each energy source
labels = np.array(
    ["Solar", "Wind", "Hydro", "Bioenergy", "Geothermal"]
)
stats = np.array(
    [
        [3, 4, 2, 5, 4],  # Solar
        [4, 3, 4, 3, 5],  # Wind
        [5, 5, 3, 4, 2],  # Hydro
    ]
)
titles = ["Solar Energy", "Wind Energy", "Hydro Energy"]
rticks = [1, 2, 3, 4, 5]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
fig, ax = plt.subplots(figsize=(10, 8), nrows=1, ncols=3, subplot_kw=dict(polar=True))
# Define the number of variables
num_vars = len(labels)

# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()

# The plot is made circular
stats = np.concatenate((stats, stats[:, [0]]), axis=1)
angles += angles[:1]
# Define colors
colors = ["#FFD700", "#00FF00", "#1E90FF"]

# Draw one radar chart for each energy source
for idx, (title, case_data) in enumerate(zip(titles, stats)):
    ax[idx].fill(angles, case_data, color=colors[idx], alpha=0.25)
    ax[idx].plot(angles, case_data, color=colors[idx], linewidth=2, linestyle='--')
    ax[idx].set_rticks(rticks)
    ax[idx].set_xticks(angles[:-1])
    ax[idx].set_xticklabels(labels)
    ax[idx].set_title(title, color=colors[idx], size=14, weight='bold')

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit
plt.tight_layout(rect=[0, 0.03, 1, 0.95])

plt.savefig("radar_69.pdf", bbox_inches="tight")
