# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define the new data for each era
labels = np.array(
    [
        "Military\nPower",
        "Cultural\nInfluence",
        "Economic\nStrength",
        "Scientific\nAdvancements",
        "Political\nStability",
    ]
)
stats = np.array(
    [
        [5, 4, 3, 2, 4],  # Ancient Egypt
        [3, 5, 4, 5, 3],  # Renaissance Europe
        [4, 3, 5, 4, 5],  # Industrial Revolution
    ]
)
titles = ["Ancient Egypt", "Renaissance Europe", "Industrial Revolution"]
rticks = [1, 2, 3, 4, 5]
suptitle = "Comparison of Characteristics Across Historical Eras"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
fig, ax = plt.subplots(figsize=(10, 8), nrows=1, ncols=3, subplot_kw=dict(polar=True))

# Define the number of variables
num_vars = len(labels)

# Compute angle for each axis
angles = np.linspace(0, 2 * np.pi, num_vars, endpoint=False).tolist()

# The plot is made circular
stats = np.concatenate((stats, stats[:, [0]]), axis=1)
angles += angles[:1]

# Define colors
colors = ["#8B4513", "#4682B4", "#808080"]  # Earthy brown, steel blue, Industrial grey

# Draw one radar chart for each historical era
for idx, (title, case_data) in enumerate(zip(titles, stats)):
    ax[idx].fill(angles, case_data, color=colors[idx], alpha=0.25)
    ax[idx].plot(
        angles, case_data, color=colors[idx], linestyle="-", linewidth=2, marker="o"
    )
    ax[idx].set_rticks(rticks)
    ax[idx].set_xticks(angles[:-1])
    ax[idx].set_xticklabels(labels, fontsize=10)
    ax[idx].set_title(title, color=colors[idx], fontsize=12, fontweight="bold")
    ax[idx].grid(True)


plt.suptitle(suptitle, fontsize=14, y=1.0)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better fit
plt.tight_layout(rect=[0, 0.03, 1, 1.5])
plt.savefig("radar_70.pdf", bbox_inches="tight")
