# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Prepare data
years = np.array([2017, 2018, 2019, 2020, 2021])  # Years
city1_temp = np.array([15, 16, 15.5, 16.5, 17])  # Avg temp in city 1
city2_temp = np.array([14, 14.5, 15, 15.2, 15.8])  # Avg temp in city 2
city3_temp = np.array([13, 13.2, 13.5, 14, 14.5])  # Avg temp in city 3

city1_precip = np.array([120, 110, 115, 130, 125])  # Precipitation in city 1
city2_precip = np.array([95, 100, 105, 110, 115])  # Precipitation in city 2
city3_precip = np.array([80, 85, 90, 95, 100])  # Precipitation in city 3

sizes_temp = np.random.randint(100, 300, size=len(years))
sizes_precip = np.random.randint(100, 300, size=len(years))

labels = ["City 1 Temperature", "City 2 Temperature", "City 3 Temperature"]
titles = ["Temperature in City 1", "Temperature in City 2", "Temperature in City 3"]
xlabel = "Year"
ylabel_temp = "Average Temperature (°C)"
ylabel_precip = "Precipitation (mm)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots with 2 rows and 3 columns
fig, axs = plt.subplots(2, 3, figsize=(18, 10))

# Define color schemes
colors_temp = ["red", "orange", "yellow"]
colors_precip = ["blue", "cyan", "skyblue"]

# Plot temperature data
for ax, temp, sizes, color, label, title in zip(
    axs[0],
    [city1_temp, city2_temp, city3_temp],
    [sizes_temp, sizes_temp, sizes_temp],
    colors_temp,
    labels,
    titles,
):
    scatter = ax.scatter(
        years,
        temp,
        s=sizes,
        c=np.linspace(0.1, 1, len(years)),
        cmap="autumn",  # Warm colors for temperature
        alpha=0.6,
        label=label,
        marker="o",
    )
    ax.plot(years, temp, linestyle="--", color=color, linewidth=2, alpha=0.7)
    ax.set_title(title)
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel_temp)
    ax.legend()

# Plot precipitation data
for ax, precip, sizes, color, label, title in zip(
    axs[1],
    [city1_precip, city2_precip, city3_precip],
    [sizes_precip, sizes_precip, sizes_precip],
    colors_precip,
    ["City 1 Precipitation", "City 2 Precipitation", "City 3 Precipitation"],
    ["Precipitation in City 1", "Precipitation in City 2", "Precipitation in City 3"],
):
    scatter = ax.scatter(
        years,
        precip,
        s=sizes,
        c=np.linspace(0.1, 1, len(years)),
        cmap="winter",  # Cool colors for precipitation
        alpha=0.6,
        label=label,
        marker="s",
    )
    ax.plot(years, precip, linestyle="-.", color=color, linewidth=2, alpha=0.7)
    ax.set_title(title)
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel_precip)
    ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better presentation
plt.tight_layout()
# Show the plot
plt.savefig("scatter_100.pdf", bbox_inches="tight")
