# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Education models/programs
models = [
    "Traditional Method",
    "Montessori",
    "Waldorf",
    "Reggio Emilia",
    "Online Learning",
    "Blended Learning",
    "Project-Based Learning",
    "Flipped Classroom",
    "Game-Based Learning",
]

# Values for each category
values = {
    "Reading Skills": [8.4, 9.2, 7.8, 8.9, 7.5, 8.0, 9.0, 8.3, 8.7],
    "Math Skills": [7.0, 8.2, 7.5, 8.0, 7.8, 8.4, 8.7, 7.6, 8.1],
    "Science Skills": [7.5, 8.0, 6.8, 7.9, 7.1, 8.3, 8.4, 7.3, 8.0],
    "Language Skills": [8.2, 9.3, 7.7, 8.5, 7.9, 8.1, 9.1, 8.4, 8.8],
    "History Knowledge": [7.8, 8.5, 7.0, 7.6, 6.9, 8.2, 8.8, 7.2, 7.7],
    "Artistic Skills": [6.5, 8.4, 8.0, 8.6, 6.8, 7.7, 7.9, 7.5, 8.3],
}

# Text labels
xlabel = "Skills Competency"
title = "Educational Models Performance across Various Skills"
supertitle = "Performance Metrics in Educational Programs"
legendlabels = list(values.keys())

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b"]
markers = ["o", "s", "D", "^", "v", "<"]

fig, axes = plt.subplots(1, 6, figsize=(15, 6), sharey=True)

for ax, (category, color, marker) in zip(axes, zip(values.keys(), colors, markers)):
    ax.scatter(values[category], models, color=color, marker=marker, edgecolor="black")
    ax.set_title(category)
    ax.set_xlim(5, 10)
    ax.axvline(x=7.5, color="gray", linestyle="--", linewidth=1)

# Set common labels
fig.text(0.5, 0.04, xlabel, ha="center", va="center")
fig.suptitle(supertitle, fontsize=14)

# Add legend
fig.legend(legendlabels, loc="upper center", bbox_to_anchor=(0.5, 1.1), ncol=3)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout(rect=[0.03, 0.07, 1, 0.95])
plt.savefig("scatter_27.pdf", bbox_inches="tight")
