# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for plotting
x_egypt = [1000, 1500, 2000]
y_egypt = [2, 3.5, 5]
sizes_egypt = [300, 400, 500]

x_rome = [800, 1200, 1800]
y_rome = [1.5, 2.5, 4.5]
sizes_rome = [300, 400, 500]

x_china = [900, 1400, 1900]
y_china = [2.2, 3.8, 6]
sizes_china = [300, 400, 500]

legend_labels = ["Ancient Egypt", "Ancient Rome", "Ancient China"]
title = "Growth of Ancient Civilizations"
xlabel = "Year (BC)"
ylabel = "Population (Millions)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(10, 6))  # Make the plot wider to fit the data better

# Scatter points
egypt_scatter = ax.scatter(
    x_egypt, y_egypt, s=sizes_egypt, alpha=0.8, color="#8B4513", marker="o"
)
rome_scatter = ax.scatter(
    x_rome, y_rome, s=sizes_rome, alpha=0.8, color="#CD5C5C", marker="s"
)
china_scatter = ax.scatter(
    x_china, y_china, s=sizes_china, alpha=0.8, color="#4682B4", marker="^"
)

# Connect points with lines
ax.plot(x_egypt, y_egypt, linestyle="--", color="#8B4513", alpha=0.8, linewidth=2)
ax.plot(x_rome, y_rome, linestyle="-.", color="#CD5C5C", alpha=0.8, linewidth=2)
ax.plot(x_china, y_china, linestyle=":", color="#4682B4", alpha=0.8, linewidth=2)

# Legend
legend = ax.legend(
    [egypt_scatter, rome_scatter, china_scatter],
    legend_labels,
    title=title,
    loc="upper left",
)

for legend_handle in legend.legendHandles:
    legend_handle._sizes = [50]  # 设置图例标记的大小

legend.get_frame().set_alpha(1)  # Make legend background opaque

# Axes labels
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("scatter_29.pdf", bbox_inches="tight")
