# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
x_christianity = [2000, 2010, 2020]
y_christianity = [2100, 2200, 2300]  # In millions
sizes_christianity = [300, 350, 400]  # Influence scores

x_islam = [2000, 2010, 2020]
y_islam = [1500, 1600, 1800]  # In millions
sizes_islam = [250, 300, 350]  # Influence scores

x_hinduism = [2000, 2010, 2020]
y_hinduism = [1000, 1100, 1150]  # In millions
sizes_hinduism = [200, 250, 300]  # Influence scores

legend_labels = ["Christianity", "Islam", "Hinduism"]
title = "Religious Adherence and Influence Over Time"
xlabel = "Year"
ylabel = "Adherents (Millions)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(6, 8))  # Adjust the size for better visualization

# Scatter points with distinct markers and colors
christianity_scatter = ax.scatter(
    x_christianity,
    y_christianity,
    s=sizes_christianity,
    alpha=0.8,
    color="#FFB6C1",
    marker="o",
)
islam_scatter = ax.scatter(
    x_islam, y_islam, s=sizes_islam, alpha=0.8, color="#87CEFA", marker="s"
)
hinduism_scatter = ax.scatter(
    x_hinduism, y_hinduism, s=sizes_hinduism, alpha=0.8, color="#FFD700", marker="^"
)

# Connect points with solid lines
ax.plot(
    x_christianity,
    y_christianity,
    linestyle="-",
    color="#FFB6C1",
    alpha=0.8,
    linewidth=2,
)
ax.plot(x_islam, y_islam, linestyle="-", color="#87CEFA", alpha=0.8, linewidth=2)
ax.plot(x_hinduism, y_hinduism, linestyle="-", color="#FFD700", alpha=0.8, linewidth=2)

# Legend
legend = ax.legend(
    [christianity_scatter, islam_scatter, hinduism_scatter],
    legend_labels,
    title=title,
    loc="upper left",
    ncol=3,
)

for legend_handle in legend.legendHandles:
    legend_handle._sizes = [80]  # 设置图例标记的大小

legend.get_frame().set_alpha(1)  # Make legend background opaque

# Axes labels
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)

# Grid for better readability
ax.grid(True, linestyle="--", alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("scatter_31.pdf", bbox_inches="tight")
