# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate new data for art and design clusters
clusters = {
    "Impressionism": np.random.multivariate_normal([2, 2], [[1, 0.5], [0.5, 1]], 20),
    "Cubism": np.random.multivariate_normal([-2, -2], [[1, -0.3], [-0.3, 1]], 20),
    "Surrealism": np.random.multivariate_normal([8, -1], [[1, 0.8], [0.8, 1]], 20),
    "Abstract": np.random.multivariate_normal([-5, 5], [[1, 0], [0, 1]], 20),
    "Minimalism": np.random.multivariate_normal([0, 8], [[0.5, 0], [0, 0.5]], 20),
    "Pop Art": np.random.multivariate_normal([5, 5], [[1, -0.5], [-0.5, 1]], 20),
}

# Variables for plot configuration
xlim = [-10, 10]
ylim = [-10, 10]
xlabel = "X Axis"
ylabel = "Y Axis"
title = "Art and Design Clusters"
legendlabels = {
    "Impressionism": "Impressionism",
    "Cubism": "Cubism",
    "Surrealism": "Surrealism",
    "Abstract": "Abstract",
    "Minimalism": "Minimalism",
    "Pop Art": "Pop Art",
}

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(8, 8))

# New color scheme for clusters
colors = {
    "Impressionism": "#FF6347",  # Tomato
    "Cubism": "#4682B4",  # SteelBlue
    "Surrealism": "#9370DB",  # MediumPurple
    "Abstract": "#3CB371",  # MediumSeaGreen
    "Minimalism": "#FFD700",  # Gold
    "Pop Art": "#FF4500",  # OrangeRed
}

# Plot each cluster
for cluster, data in clusters.items():
    plt.scatter(
        data[:, 0],
        data[:, 1],
        c=colors[cluster],
        alpha=0.7,
        edgecolors="w",
        s=100,
        label=legendlabels[cluster],
    )

# Set limits
plt.xlim(xlim)
plt.ylim(ylim)

# Set labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Remove grid
plt.grid(False)

# Enable legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("scatter_35.pdf", bbox_inches="tight")
