
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# New societal dataset clusters
clusters = {
    "Age_Group_Youth": np.random.multivariate_normal([20, 30000], [[20, 1000], [1000, 500000]], 50),
    "Age_Group_Adults": np.random.multivariate_normal([40, 60000], [[20, 2000], [2000, 800000]], 50),
    "Age_Group_Seniors": np.random.multivariate_normal([65, 40000], [[15, 800], [800, 250000]], 50),
    "Income_Group_Low": np.random.multivariate_normal([30, 20000], [[10, 500], [500, 100000]], 50),
    "Income_Group_Middle": np.random.multivariate_normal([45, 50000], [[15, 1000], [1000, 300000]], 50),
    "Income_Group_High": np.random.multivariate_normal([50, 100000], [[10, 1500], [1500, 800000]], 50),
}

# Variables for plot configuration
xlim = (0, 100)  # Example: age range
ylim = (0, 120000)  # Example: income range
xlabel = "Age"
ylabel = "Income"
xticks = None
yticks = None
xtickslabel = None
ytickslabel = None
title = "Societal Age and Income Groups"
axhline = None
axvline = None
legendlabels = {
    "Age_Group_Youth": "Youth (18-25)",
    "Age_Group_Adults": "Adults (26-45)",
    "Age_Group_Seniors": "Seniors (60+)",
    "Income_Group_Low": "Low Income",
    "Income_Group_Middle": "Middle Income",
    "Income_Group_High": "High Income",
}

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the scatter plot
plt.figure(figsize=(8, 6))

# New colors for each cluster
colors = {
    "Age_Group_Youth": "#FF5733",
    "Age_Group_Adults": "#33FF57",
    "Age_Group_Seniors": "#3357FF",
    "Income_Group_Low": "#F39C12",
    "Income_Group_Middle": "#8E44AD",
    "Income_Group_High": "#1ABC9C",
}

# New markers for each cluster
markers = {
    "Age_Group_Youth": "o",
    "Age_Group_Adults": "s",
    "Age_Group_Seniors": "D",
    "Income_Group_Low": "v",
    "Income_Group_Middle": "^",
    "Income_Group_High": "P",
}

for cluster, data in clusters.items():
    plt.scatter(data[:, 0], data[:, 1], c=colors[cluster], marker=markers[cluster], label=legendlabels[cluster], alpha=0.7)

# Set plot limits
if xlim:
    plt.xlim(xlim)
if ylim:
    plt.ylim(ylim)

# Set axis labels and title
if xlabel:
    plt.xlabel(xlabel)
if ylabel:
    plt.ylabel(ylabel)
if title:
    plt.title(title)

# Add legend
plt.legend()

# Remove grid for a cleaner look
plt.grid(False)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("scatter_36.pdf", bbox_inches="tight")
