
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data points for each group representing communication technologies
g4 = [(10, 450), (20, 350)]
g5 = [(30, 300), (40, 250)]
wifi = [(15, 400), (25, 330)]
bluetooth = [(5, 500), (15, 450)]
zigbee = [(3, 520), (10, 480)]
lorawan = [(2, 600), (8, 550)]
labels = ["4G", "5G", "Wi-Fi", "Bluetooth", "Zigbee", "LoRaWAN"]
xlabel = "Data Rate (Mbps)"
ylabel = "Signal Quality (WRMSE)"
title = "Communication Technologies: Signal Quality vs Data Rate"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a scatter plot
fig, ax = plt.subplots(figsize=(8, 6))

# Define color and marker scheme
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b"]
markers = ["o", "s", "D", "^", "v", "<"]

# Plot each group with different color and marker
ax.scatter(*zip(*g4), color=colors[0], label=labels[0], marker=markers[0])
ax.scatter(*zip(*g5), color=colors[1], label=labels[1], marker=markers[1])
ax.scatter(*zip(*wifi), color=colors[2], label=labels[2], marker=markers[2])
ax.scatter(*zip(*bluetooth), color=colors[3], label=labels[3], marker=markers[3])
ax.scatter(*zip(*zigbee), color=colors[4], label=labels[4], marker=markers[4])
ax.scatter(*zip(*lorawan), color=colors[5], label=labels[5], marker=markers[5])

# Add legend
ax.legend(loc="upper right")

# Add labels and title
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14)
ax.grid(True)  # Adding grid

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
fig.tight_layout()
plt.savefig("scatter_40.pdf", bbox_inches="tight")
