
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Weather-related data for three seasons
np.random.seed(0)
# Generate sample data for three seasons with adjusted positions and spread
x_winter = np.random.normal(-2, 1, 100)
y_winter = np.random.normal(0, 0.5, 100)

x_spring = np.random.normal(0, 1, 100)
y_spring = np.random.normal(2, 0.5, 100)

x_summer = np.random.normal(2, 1, 100)
y_summer = np.random.normal(4, 0.5, 100)

# Labels and other text parameters
xlabel = "Temperature (°C)"
ylabel = "Humidity (%)"
title = "Weather Data: Temperature vs. Humidity"
suptitle = "Seasonal Weather Patterns"
labels = ["Winter", "Spring", "Summer"]
legend_location = "upper left"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(10, 7))

# Plot the data with optimized colors and markers
plt.scatter(x_winter, y_winter, c="#1f77b4", marker='o', label=labels[0], alpha=0.7)
plt.scatter(x_spring, y_spring, c="#2ca02c", marker='s', label=labels[1], alpha=0.7)
plt.scatter(x_summer, y_summer, c="#d62728", marker='^', label=labels[2], alpha=0.7)

# Add titles and labels
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.suptitle(suptitle)

# Add the legend with adjusted order of labels
plt.legend(loc=legend_location, frameon=True)

# Add grid for better readability
plt.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with a tight layout to minimize white space
plt.tight_layout(rect=[0, 0.03, 1, 0.95])  # Adjust the rect parameter to fit the suptitle
plt.savefig("scatter_41.pdf", bbox_inches="tight")
